<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Meme extends Model
{
    use Sluggable;

    protected $fillable = ['title', 'slug', 'width', 'height'];

    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }

    public function scopeAdmin($query)
    {
        return $query->where('usermeme', '=', false);
    }
}
