<?php
namespace App\Models;

use Auth;

trait Favoritable{

    public function favorites()
    {
        return $this->belongsToMany(Album::class, 'favorites')->withTimestamps();
    }

    public function getFavoriteCountAttribute()
    {
        $count = 0;
        foreach ($this->favorites AS $favorite) {
            $count = $count + 1;
        }
        return $count;
    }

    public function favorite(Album $album)
    {
        if(! $this->checkIfFavorited($album)){
            return $this->favorites()->attach($album);
        }
    }

    public function unFavorite(Album $album)
    {
        if($this->checkIfFavorited($album)){
            return $this->favorites()->detach($album);
        }
    }

    public function checkIfFavorited(Album $album)
    {
        return $this->favorites()->where('album_id', $album->id)->exists();
    }

}
