<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Comment extends Model
{
    use Votable;
    use Reportable;
    use SoftDeletes;

    protected $fillable = ['body', 'user_id', 'album_id', 'deleted_reason', 'deleted_by'];

    protected $dates = [
        'created_at',
        'deleted_at',
        'updated_at',
    ];

    public static function boot()
    {
        parent::boot();

        static::deleting(function ($model) {

        });
   }

    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    //
    public function deletedBy()
    {
        return $this->belongsTo(User::class, 'deleted_by');
    }

    public function images()
    {
        return $this->belongsTo(Album::class, 'album_id');
    }

    public function album()
    {
        return $this->belongsTo(Album::class, 'album_id');
    }

    public function linkify($allowed_types = array('jpg', 'jpeg', 'png', 'gif'), $protocols = array('http','user'), array $attributes = array())
    {
        $value = $this->body;
        // Link attributes
        $attr = '';
        foreach ($attributes as $key => $val) {
            $attr = ' ' . $key . '="' . htmlentities($val) . '"';
        }

        $links = array();

        // Extract existing links and tags
        $value = preg_replace_callback('~(<a .*?>.*?</a>|<.*?>)~i', function ($match) use (&$links) { return '<' . array_push($links, $match[1]) . '>'; }, $value
         );

        // Extract text links for each protocol
        foreach ((array)$protocols as $protocol) {
            switch ($protocol) {
                case 'http':
                case 'https':   $value = preg_replace_callback('~(?:(https?)://([^\s<]+)|(www\.[^\s<]+?\.[^\s<]+))(?<![\.,:])~i', function ($match) use ($protocol, &$links, $attr, $allowed_types) {
                     if ($match[1])
                        $protocol = $match[1];
                    $link = $match[2] ?: $match[3];
                    $dot_pos = strrpos($link, '.');
                    $ourDomain = config('app.url');
                    $reg_exUrl = "/(imgur.com|".str_replace('http://', '', $ourDomain).")/";
                    if (!preg_match($reg_exUrl,$link)){
                        return $link;
                    }
                    if(!$dot_pos) {
                        return $link;
                    }
                    /**
                     * Get substring after last dot
                     */
                    $extension = substr($link, $dot_pos + 1);

                    if(!in_array($extension, $allowed_types)) {
                        /**
                         * Extension not in allowed types
                         */
                        return $link;
                    }
                    return '<' . array_push($links, "<a class='preview' $attr href=\"$protocol://$link\">$protocol://$link</a>") . '>'; }, $value);
                    break;
                case 'mail':    $value = preg_replace_callback('~([^\s<]+?@[^\s<]+?\.[^\s<]+)(?<![\.,:])~', function ($match) use (&$links, $attr) { return '<' . array_push($links, "<a $attr href=\"mailto:{$match[1]}\">{$match[1]}</a>") . '>'; }, $value); break;
                case 'user': $value = preg_replace_callback('~(?<!\w)[@#](\w++)~',
                function ($match) use (&$links, $attr) { return '<' . array_push($links, "<a $attr href=".config('app.url')."/user/" . ($match[0][0] == '@' ? '' : 'search/%23') . $match[1]  . "\>{$match[0]}</a>") . '>'; }, $value); break;
                default:
                    $value = preg_replace_callback('~' . preg_quote($protocol, '~') . '://([^\s<]+?)(?<![\.,:])~i',
                    function ($match) use ($protocol, &$links, $attr)
                    {
                        return '<' . array_push($links, "<a $attr href=\"$protocol://{$match[1]}\">{$match[1]}</a>") . '>';
                    }, $value);
                break;
            }
        }

        // Insert all link
        $this->body = preg_replace_callback('/<(\d+)>/', function ($match) use (&$links) { return $links[$match[1] - 1]; }, $value);
    }

    public function createdAt()
    {
        $created_at = $this->created_at->diffForHumans();
        $created_at = str_replace([' minutes', ' minute'], ' min', $created_at);
        $created_at = str_replace([' hours', ' hour'], ' h', $created_at);
        $created_at = str_replace([' months', ' month'], ' m', $created_at);

        if(preg_match('(years|year)', $created_at)){
            $created_at = $this->created_at->toFormattedDateString();
        }

        return $created_at;
    }
}
