<?php

namespace App\Listeners;

use App\Events\SomebodyContactedUsEvent;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Mail\SomebodyContactedUsMail;
use App\Setting;
use Mail;

class SomebodyContactedUsListener
{

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * Handle the event.
     *
     * @param  SomebodyContactedUsEvent  $event
     * @return void
     */
    public function handle(SomebodyContactedUsEvent $event)
    {
        $email = Setting::where('name','website-email')->first();
        if($email)
            Mail::to($email->body)->send( new SomebodyContactedUsMail($event));
    }
}
