<?php

namespace App\Http\Middleware;

use Closure;
use Auth;

class NormalUser
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user();

        if ($user and $user->banned_at != null) {
            $reason = $user->reason;
            Auth::logout();
            if ($request->ajax()) {
                return response()->json([
                    'error' => 'You have been banned. <br>Reason: ' . $reason
                ], 403);
            }

            abort(403, 'You have been banned. Reason: ' . $reason);
        }
        return $next($request);
    }
}
