<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Models\User;

use App\Models\Comment;

use App\Models\Favorite;

use App\Models\Image;

use App\Models\Album;

use Auth;

class UserController extends Controller
{
    private $userNofFoundMessage = 'The user you are looking for could not be found.';

    public function enter()
    {

    }

    public function comments(Request $request, $username)
    {
        // $user = User::with(array(
        //         'comments.album.images' => function ($query)
        //         {
        //             $query->where('order', 1);
        //         }
        //     ))->with('comments.votes')
        //         ->with(array(
        //         'comments' => function ($query)
        //         {
        //             $query->orderBy('created_at', 'desc');
        //         }
        //     ))->where('username', $username)->first();

        $user = User::where('username', $username)->first();

        if($user == null){
            abort(404, $this->userNofFoundMessage);
        }

        $comments = Comment::with('album.images')->with('votes')->orderBy('id', 'desc')->where('user_id', $user->id)->get();

        return view('user.comments')->withComments($comments)->withUser($user);
    }

    public function submitted(Request $request, $username){

        $user = User::with(array(
                'albums.images' => function ($query)
                {
                    $query->orderBy('order', 'asc');
                }
            ))->with('albums.votes')
                ->with(array(
                'albums' => function ($query)
                {
                    $query->orderBy('created_at', 'desc')->published();
                }
            ))->where('username', $username)->first();

        if($user == null){
            abort(404, $this->userNofFoundMessage);
        }

        return view('user.submitted')->withUser($user);
    }

    public function favorites(Request $request, $username)
    {

        $user = User::where('username', $username)->first();

        if($user == null){
            abort(404, $this->userNofFoundMessage);
        }

        $favorites = Favorite::with(array(
                'album.images' => function ($query)
                {
                    $query->orderBy('order', 'asc');
                }
            ))->with('album.votes')
            ->where('user_id', $user->id)->orderBy('created_at', 'desc')->get();

        return view('user.favorites')->withFavorites($favorites)->withUser($user);
    }

    public function images(Request $request, $username)
    {

        $user = User::where('username', $username)->first();

        if($user == null){
            abort(404, $this->userNofFoundMessage);
        }

        if(Auth::user() == $user)
            $images = Image::with('album')->where('user_id', $user->id)->orderBy('created_at', 'desc')->get();
        else
            $images = Image::with('album')->where('user_id', $user->id)->public()->orderBy('created_at', 'desc')->get();

        return view('user.images')->withImages($images)->withUser($user);
    }

    public function albums(Request $request, $username)
    {
        $user = User::where('username', $username)->first();

        if($user == null){
            abort(404, $this->userNofFoundMessage);
        }

        if(Auth::user() == $user)
            $albums = Album::with(array(
                'images' => function ($query) {
                    $query->orderBy('order', 'asc');
                }
            ))->with('votes')
            ->where('user_id', $user->id)->orderBy('created_at', 'desc')->get();
        else
            $albums = Album::with(array(
                'images' => function ($query) {
                    $query->orderBy('order', 'asc');
                }
            ))->with('votes')
            ->where('user_id', $user->id)->public()->orderBy('created_at', 'desc')->get();

        return view('user.albums')->withAlbums($albums)->withUser($user);
    }
}
