<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Page;
use Route;
use Session;
use App\Models\RemovalRequest;
use App\Events\SomebodyContactedUsEvent;

class PageController extends Controller
{
    /**
     * Show the terms.
     *
     * @return \Illuminate\Http\Response
     */
    public function page()
    {
        $page = Page::where('slug', Route::current()->uri())->first();
        return view('pages.show')->withPage($page);
    }

    /**
     * Show the request deletion form.
     *
     * @return \Illuminate\Http\Response
     */
    public function removalRequestShow()
    {
        $page = Page::where('slug', 'removalrequest')->first();
        return view('pages.removal')->withPage($page);
    }

    /**
     * Contact.
     *
     * @return \Illuminate\Http\Response
     */
    public function removalrequest(Request $request)
    {
        $this->validate($request, [
            'email' => 'required|email',
            'images' => 'required',
            'message' => 'required',
        ]);

        $removalRrequest = new RemovalRequest();
        $removalRrequest->email = $request->email;
        $removalRrequest->images = $request->images;
        $removalRrequest->message = $request->message;
        $reference = null;
        do{
            $reference = str_random(7);
        } while (RemovalRequest::where('reference', $reference)->first() != null);
        $removalRrequest->reference = $reference;
        $removalRrequest->save();
        Session::flash('request.sent', 'Your request has been sent. Give use 24 hours to respond. Your reference id is '.$reference .' If you need to contact us again use that reference number.');

        $page = Page::where('slug', 'removalrequest')->first();
        return view('pages.removal')->withPage($page);
    }

    /**
     * Show the contact form.
     *
     * @return \Illuminate\Http\Response
     */
    public function contactShow()
    {
        $page = Page::where('slug', 'contact')->first();
        return view('pages.contact')->withPage($page);
    }

    /**
     * Contact.
     *
     * @return \Illuminate\Http\Response
     */
    public function contact(Request $request)
    {
        $this->validate($request, [
            'email' => 'required|email',
            'message' => 'required',
        ]);
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('message.sent', 'Your message has been sent. Give use 24 hours to respond.');
        } else {
            event(new SomebodyContactedUsEvent($request));
            Session::flash('message.sent', 'Your message has been sent. Give use 24 hours to respond.');
        }
        $page = Page::where('slug', 'contact')->first();
        return view('pages.contact')->withPage($page);
    }
}
