<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Meme;

use App\Models\Album;

use App\Models\Image;

use Session;

use Purifier;

use Carbon\Carbon;

use ImgResizer;

use Validator;

use Auth;

use App\Http\Requests;

class MemeController extends Controller
{
    public function index(Request $request)
    {
        $routeName = $request->route()->getName();
        $memes = Meme::orderBy('id', 'desc')->admin()->get();
        return view('meme.index', compact('memes', 'routeName'));
    }

    public function showUpload(Request $request)
    {
        $routeName = $request->route()->getName();
        return view('meme.upload', compact('routeName'));
    }

    public function new(Request $request)
    {
        $this->validate($request, [
            'title' => 'required|numeric|min:3,max:160',
            'file' => 'required|mimes:jpeg,bmp,png|dimensions:min_width=600',
            ],
            [
                'file.dimensions'  => 'Mimimum width for memes is 600px. Try again!',
            ]
        );

        $uploadFolder = 'usermemes/';
        $file = $request->file('file');
        $meme = new Meme();
        $meme->title = Purifier::clean($request->title);
        $meme->title = trim($meme->title);
        $meme->title = preg_replace('/[^a-zA-Z0-9\']/', ' ', $meme->title);
        $meme->title = str_replace("'", '', $meme->title);
        $meme->title = trim($meme->title);
        $meme->extension = strtolower($file->getClientOriginalExtension());
        $meme->usermeme = true;
        $meme->save();
        $name = $meme->slug .'.'. strtolower($file->getClientOriginalExtension());

        $file->move($uploadFolder, $name);
        $width = ImgResizer::make($uploadFolder.$name)->width();
        $image = ImgResizer::make($uploadFolder.$name);

        if($width > 600){
          $image->resize(600, null, function ($constraint) {
              $constraint->aspectRatio();
          });
        }

        $image->save($uploadFolder.$name);
        $meme->width = $image->width();
        $meme->height = $image->height();
        $meme->save();

        $routeName = $request->route()->getName();

        return view('meme.create', compact('meme', 'routeName'));
    }

    public function existing(Request $request, $id)
    {
        $routeName = $request->route()->getName();
        $meme = Meme::find($id);
        return view('meme.create', compact('meme', 'routeName'));
    }

    public function save(Request $request)
    {
        $request->meme = substr($request->meme, 22);
        $request->meme = str_replace(' ','+',$request->meme);
        $memeDecoded = base64_decode($request->meme);

        $albumHash = "";
        $imageHash = "";

        do{
            $albumHash = str_random(7);
        } while (Album::where('hash', $albumHash)->withTrashed()->first() != null);

        $album = new Album();
        $album->hash = $albumHash;

        if(Auth::user() != null){
            $album->user_id = Auth::user()->id;
        }

        $album->save();
        Session::push('album.hash', $album->hash);

        $current = Carbon::now();
        $year = $current->year;
        $month = $current->month;
        $day = $current->day;
        $hour = $current->hour;
        $folder = 'uploads/'.$year.'/'.$month.'/'.$day.'/'.$hour;

        if( ! file_exists($folder)) {
            $oldmask = umask(0);
            mkdir($folder, 0775, true);
            mkdir($folder . '/thumb/', 0775, true);
            umask($oldmask);
        }

        do{
            $imageHash = str_random(7);
        } while (Image::where('hash', $imageHash)->withTrashed()->first() != null);
        $name = $imageHash .'.'.'jpg';
        file_put_contents('tmp/'.$name, $memeDecoded);

        @rename('tmp/'.$name, $folder.'/'.$name);

        $thumbnailName = $name;

        $width = ImgResizer::make($folder.'/'.$name)->width();
        $image = ImgResizer::make($folder.'/'.$name);
        if($width > 600){
          $image->resize(600, null, function ($constraint) {
              $constraint->aspectRatio();
          });
        }
        $image->save($folder.'/'.$name);

        $thumbnailImage = ImgResizer::make($folder.'/'.$name)->fit(180, 180);
        $thumbnailImage->save( $folder . '/thumb/'. $thumbnailName);
        $image = new Image();
        $image->hash = $imageHash;
        $image->path = $folder;
        $image->album_id = $album->id;
        $image->extension = 'jpg';
        $image->order = 1;

        if(Auth::user() != null){
            $image->user_id = Auth::user()->id;
        }
        $image->save();

        return redirect()->route('album.show', [$album->hash]);
    }
}
