<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

// use Illuminate\Support\Facades\Request;

use App\Models\Image;

use ImgResizer;

use Session;

use Validator;

use Auth;

use Storage;

use Carbon\Carbon;

use Illuminate\Database\Eloquent\ModelNotFoundException;

use Purifier;

use Throttle;

use Cache;

class ImageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    public function thumb($hash, $extension)
    {
        $image = null;
        $image = Cache::rememberForever('thumb_'.$hash, function() use($hash) {
            return Image::where('hash', $hash)->first();
        });
        // return ImgResizer::make($image->hash . '.jpg')->response($image->extension);

        if($image == null)
            abort(404, 'The image you are looking for could not be found.');

        $imagefile = file_get_contents($image->path.'/thumb/'.$image->hash . '.' . $image->extension);

        header('Content-type: image/jpeg;');
        header("Content-Length: " . strlen($imagefile));
        echo $imagefile;
    }

    public function image($hash, $extension)
    {
        $image = null;

        $image = Cache::rememberForever('image_'.$hash, function() use($hash){
            return Image::where('hash', $hash)->first();
        });
        // return ImgResizer::make($image->hash . '.jpg')->response($image->extension);

        if($image == null)
            abort(404, 'The image you are looking for could not be found.');

        $imagefile = file_get_contents($image->path.'/'.$image->hash . '.' . $image->extension);

        header('Content-type: image/jpeg;');
        header("Content-Length: " . strlen($imagefile));
        echo $imagefile;
    }

    public function deleteShow($hash)
    {
        $image = Image::where('deletehash', $hash)->first();
        if($image){
            return view('image.deleteconfirm', compact('image'));
        }
    }

    public function deleteImage(Request $request)
    {
        $image = Image::where('hash', $request->hash)->first();
        if($image){
            $count = $image->album->images->count();
            $filename = $image->hash .'.'. $image->extension;
            @unlink(public_path($filename));
            @unlink(public_path() . '/thumb/'. $filename);
            if($count == 1){
                $image->album->delete();
            }
            $image->delete();
                return response()->json([
                    'status' => 'success',
                    'msg' => 'Image deleted!',
                    'count' => $count
                ], 201);

            // return view('image.deleted');
        }
    }

    public function checkIfOwner($image){
        $owner = false;
        if(Session::has('image.hash')){
            foreach (Session::get('image.hash') as $imagehash ){
                if ($imagehash == $image->hash){
                    $owner = true;
                    break;
                }
            }
        }

        if(Auth::user() != null){
            if($image->user_id == Auth::user()->id){
                $owner = true;
            }
        }

        return $owner;
    }


    public function save(Request $request)
    {
        $image = Image::where('hash', $request->image)->first();
        $owner = $this->checkIfOwner($image->album);

        if($request->ajax() && $owner){
            $image = Image::where('hash', $request->image)->first();
            if($image){
                $request->description = Purifier::clean($request->description);
                $request->description = preg_replace('/(?:\s*<br[^>]*>\s*){3,}/s', "<br><br>", $request->description);
                $request->title = Purifier::clean($request->title);
                // $request->title = preg_replace('/(?:\s*<br[^>]*>\s*){3,}/s', "<br><br>", $request->title);
                // echo "desc:" . $request->description;
                // $image->update($request->all());
                $image->title = $request->title;
                $image->description = $request->description;
                $image->save();
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, $hash)
    {
        $image = Image::where('hash',$hash)->first();
        $routeName = $request->route()->getName();

        if($image == null){
            abort(404, 'The image you are looking for could not be found.');
        }

        $owner = $this->checkIfOwner($image);

        return view('image.show', compact('image', 'owner', 'routeName'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
