<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Models\Comment;

use App\Models\Album;

use App\Models\ReportOptions;

use Auth;

use Purifier;

class CommentController extends Controller
{

    public function report(Request $request){
        if($request->ajax()){
            $comment = Comment::where('id',$request->id)->first();
            if($comment){
                $reportReason = ReportOptions::find($request->reason);
                $status = $comment->report($reportReason->name);
                if($status){
                    return response()->json([
                        'status' => $status
                    ], 201);
                } else{
                    return response()->json([
                        'error' => 'You need to be logged in to do that.'
                    ], 401);
                }
            } else{
                return response()->json([
                    'error' => 'Comment has been deleted.'
                ], 401);
            }
        }
    }

    public function vote(Request $request)
    {
        if($request->ajax()){
            $comment = Comment::where('id',$request->comment)->first();
            if($comment){
                if($comment->vote($request->action)){
                    return response()->json([
                        'status' => 'success',
                        'points' => $comment->getPointsAttribute(),
                    ], 201);
                } else{
                    return response()->json([
                        'error' => 'User not logged in.'
                    ], 401);
                }
            } else{
                return response()->json([
                    'error' => 'Comment has been deleted.'
                ], 401);
            }
        }
    }

    public function add(Request $request)
    {
        if($request->ajax()){
            if(Auth::user() != null){
                $user = Auth::user();
                $album = Album::where('hash', $request->album)->first();
                $comment = new Comment();
                $comment->body = Purifier::clean($request->body);
                $comment->linkify();
                $comment->album_id = $album->id;
                $comment->user_id = $user->id;
                $comment->save();
                $comment->vote('upvote');
                return response()->json([
                    'status' => 'success',
                    'comment' => view('album.ajax.addcomment')->with(compact('comment'))->render(),
                ], 201);
            } else
            {
                return response()->json([
                    'error' => 'User not logged in.'
                ], 401);
            }
        }
    }

}
