<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Models\Album;

use App\Models\Image;

use App\Models\Comment;

use App\Models\Setting;

use App\Models\Vote;

use App\Models\Tag;

use App\Models\ReportOptions;

use Validator;

use Auth;

use Session;

use Carbon\Carbon;

use Cookie;

use Response;

use Illuminate\Database\Eloquent\ModelNotFoundException;

use Debugbar;

use ImgResizer;

use DB;

include( base_path('vendor/grabzit/grabzit/lib/GrabzItClient.class.php'));
// include( app_path().'vendor/grabzit/grabzit/cnfig.php');

use Purifier;
//
class AlbumController extends Controller
{

    public function grabzit()
    {
        $grabzIt = new \GrabzItClient("YmIwYTVmODFiNzEwNGI0MmE0ZDRiNTZlZGUxOTE5Njc=", "CD91OlY/PyZyOgs/Pz9vPxc/Lj8/Pz8bVz9gPy0/QwI=");
        $grabzIt->URLToImage("http://www.google.com");
        $grabzIt->Save("http://images.dev/handler.php");
        echo "ok";
    }

    public function report(Request $request){
        if($request->ajax()){
            $album = Album::find($request->id);
            if($album){
                $reportReason = ReportOptions::find($request->reason);
                $status = $album->report($reportReason->name);
                if($status){
                    return response()->json([
                        'status' => $status
                    ], 201);
                } else{
                    return response()->json([
                        'error' => 'You need to be logged in to do that.'
                    ], 401);
                }
            } else{
                return response()->json([
                    'error' => 'Album has been deleted.'
                ], 401);
            }
        }
    }

    public function checkIfOwner(Album $album)
    {
        $owner = false;
        if(Session::has('album.hash')){
            foreach (Session::get('album.hash') as $albumhash ){
                if ($albumhash == $album->hash){
                    $owner = true;
                    break;
                }
            }
        }
        if(Auth::user() != null){
            if($album->user_id == Auth::user()->id){
                $owner = true;
            }
        }
        return $owner;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function topic(Request $request, $slug)
    {
        $tag = Tag::where('slug', $slug)->first();
        $popularityTime = "Today's";
        $routeName = $request->route()->getName();
        $albums = $this->getAlbums($tag->id);
        switch ($routeName) {
            case 'topic.today':
                $albums->orderBy('points', 'desc')->whereDay('published_at', '=', Carbon::now()->day);
            break;

            case 'topic.week':
                $monday = Carbon::parse('last monday')->startOfDay();
                $sunday = Carbon::parse('next sunday')->endOfDay();
                $albums->orderBy('points', 'desc')->whereBetween('published_at', [$monday, $sunday]);
            break;

            case 'topic.month':
                $albums->orderBy('points', 'desc')->whereMonth('published_at', '=', Carbon::now()->month);
            break;

            case 'topic.year':
                $albums->orderBy('points', 'desc')->whereYear('published_at', '=', Carbon::now()->year);
            break;

            case 'topic.all':
                $albums->orderBy('points', 'desc');
            break;

            case 'topic.popularity':
                $tmpalbums = $albums->orderBy('views', 'desc')->orderBy('points', 'desc')->whereDay('published_at', '=', Carbon::now()->day);
                $tmpalbums = $tmpalbums->published()->paginate(5);
                $count = 0;
                foreach ($tmpalbums as $key) {
                    $count += 1;
                };
                $monday = Carbon::parse('last monday')->startOfDay();
                $now = Carbon::now();

                if($count == 0){
                    $popularityTime = "This week's";
                    $albums = $this->getAlbums($tag->id);
                    $tmpalbums = $albums->orderBy('views', 'desc')->orderBy('points', 'desc')->whereBetween('published_at', [$monday, $now]);
                    $tmpalbums = $tmpalbums->published()->paginate(5);

                    $count = 0;
                    foreach ($tmpalbums as $key) {
                        $count += 1;
                    };
                    if($count == 0){
                        $popularityTime = "This month's";
                        $albums = $this->getAlbums($tag->id);
                        $tmpalbums = $albums->orderBy('views', 'desc')->orderBy('points', 'desc')->whereMonth('published_at', '=', Carbon::now()->month);
                        $tmpalbums = $tmpalbums->published()->paginate(5);
                    }
                }
            break;

            case 'topic.random':
                $albums->orderByRaw('RAND()');
            break;
        }

        $albums = $albums->published()->orderBy('published_at', 'desc')->paginate(30);

        if($request->ajax()){
            return [
                'posts' => view('album.ajax.index')->with(compact('albums'))->render(),
                'next_page' => $albums->nextPageUrl()
            ];
        }
        $album = null;
        $tags = Tag::all();

        $routeName = explode('.', $routeName);
        $time = $routeName[1];
        $routeName = $routeName[0];

        return view('album.index', compact('albums', 'album', 'tags', 'tag', 'routeName', 'time', 'popularityTime'));
    }

    public function getAlbums($tag_id = null){

        $albums = Album::with(array(
                'images' => function ($query) {
                    $query->orderBy('order', 'asc');
                }
            ))
            ->with('votes')
            ->leftJoin('votes', 'votes.votable_id', '=', 'albums.id')
            ->selectRaw(
                'albums.*, count(case votes.status when "upvote" then 1 else null end) - count(case votes.status when "downvote" then 1 else null end) as points'
            )
            ->where('votes.votable_type','App\Models\Album')
            ->groupBy('albums.id');
        if($tag_id != null)
            $albums->where('tag_id', $tag_id);
        return $albums;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $routeName = $request->route()->getName();

        $albums = $this->getAlbums();
        $popularityTime = "Today's";
        switch ($routeName) {
            case 'viral.today':
                $albums->orderBy('points', 'desc')->whereDay('published_at', '=', Carbon::now()->day);
            break;

            case 'viral.week':
                $monday = Carbon::parse('last monday')->startOfDay();
                $sunday = Carbon::parse('next sunday')->endOfDay();
                $albums->orderBy('points', 'desc')->whereBetween('published_at', [$monday, $sunday]);
            break;

            case 'viral.month':
                $albums->orderBy('points', 'desc')->whereMonth('published_at', '=', Carbon::now()->month);
            break;

            case 'viral.year':
                $albums->orderBy('points', 'desc')->whereYear('published_at', '=', Carbon::now()->year);
            break;

            case 'viral.all':
                $albums->orderBy('points', 'desc');
            break;

            case 'viral.popularity':
                $tmpalbums = $albums->orderBy('views', 'desc')->orderBy('points', 'desc')->whereDay('published_at', '=', Carbon::now()->day);
                $tmpalbums = $tmpalbums->published()->paginate(5);
                $count = 0;
                foreach ($tmpalbums as $key) {
                    $count += 1;
                };
                $monday = Carbon::parse('last monday')->startOfDay();
                $now = Carbon::now();

                if($count == 0){
                    $popularityTime = "This week's";
                    $albums = $this->getAlbums();
                    $tmpalbums = $albums->orderBy('views', 'desc')->orderBy('points', 'desc')->whereBetween('published_at', [$monday, $now]);
                    $tmpalbums = $tmpalbums->published()->paginate(5);

                    $count = 0;
                    foreach ($tmpalbums as $key) {
                        $count += 1;
                    };
                    if($count == 0){
                        $popularityTime = "This month's";
                        $albums = $this->getAlbums();
                        $tmpalbums = $albums->orderBy('views', 'desc')->orderBy('points', 'desc')->whereMonth('published_at', '=', Carbon::now()->month);
                        $tmpalbums = $tmpalbums->published()->paginate(5);
                    }
                }
            break;

            case 'viral.random':
                $albums->orderByRaw('RAND()');
            break;
        }
        $albums = $albums->published()->orderBy('published_at', 'desc')->paginate(30);

        if($request->ajax()){
            return [
                'posts' => view('album.ajax.index')->with(compact('albums'))->render(),
                'next_page' => $albums->nextPageUrl()
            ];
        }
        $album = null;
        $tags = Tag::all();

        $routeName = explode('.', $routeName);
        $time = $routeName[1];
        $routeName = $routeName[0];

        return view('album.index', compact('albums', 'album', 'tags', 'routeName', 'time', 'popularityTime'));
    }

    public function favorite(Request $request)
    {
        if($request->ajax()){
            $album = Album::where('hash',$request->album)->first();

            if(Auth::user() != null){
                $user = Auth::user();
                if($request->action == 'favorite'){
                    $user->favorite($album);
                }
                elseif($request->action == 'unfavorite'){
                    $user->unFavorite($album);
                }
                return response()->json([
                    'status' => 'success'
                ], 201);
            }
            else
            {
                return response()->json([
                    'error' => 'User not logged in.'
                ], 401);
            }
        }
    }

    public function vote(Request $request)
    {
        if($request->ajax()) {
            $album = Album::where('hash',$request->album)->first();
            if($album){
                if($album->vote($request->action)){
                    return response()->json([
                        'status' => 'success',
                        'points' => $album->getPointsAttribute(),
                    ], 201);
                } else{
                    return response()->json([
                        'error' => 'User not logged in.'
                    ], 401);
                }
            } else{
                return response()->json([
                    'error' => 'Album has been deleted.'
                ], 401);
            }

        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function showUpload()
    {
        return view('album.upload');
    }

    public function saveTitle(Request $request)
    {
        $album = Album::where('hash', $request->album)->first();
        $owner = $this->checkIfOwner($album);

        if($request->ajax() && $owner && !$album->published){
            $album->title = Purifier::clean($request->title);
            $album->title = trim($album->title);
            $album->title = preg_replace('/[^a-zA-Z0-9\']/', ' ', $album->title);
            $album->title = str_replace("'", '', $album->title);
            $album->title = trim($album->title);

            if($album->title != ''){
                $album->slug = null;
                $album->save();
            }
        }
    }

    public function showVideoUpload(Request $request)
    {
        $routeName = $request->route()->getName();
        return view('video2gif.upload', compact('routeName'));
    }

    public function video2gif(Request $request)
    {
        $this->validate($request, [
            'start' => 'required|numeric|between:0,240',
            'duration' => 'required|numeric|between:0,15',
            'file' => 'required|mimes:flv,mp4,mkv,3gp,mpg,avi|max:6144',
            ],
            [
                'file.max' => 'The file may not be greater than 5 Megabytes.',
                'start.between'  => 'Start must be value between 0 and 240 seconds.',
                'duration.between' => 'Duration must be value between 0 and 15.',
            ]
        );
        $start = (int)$request->start;
        $duration = (int)$request->duration;
        if($duration > 15)
            $duration = 15;

        $routeName = $request->route()->getName();
        header('X-Accel-Buffering: no');
        header('Content-Encoding: none;');
        echo view('video2gif.uploading', compact('routeName'))->render();

        $albumHash = "";
        $imageHash = "";

        do{
            $albumHash = str_random(7);
        } while (Album::where('hash', $albumHash)->withTrashed()->first() != null);

        $album = new Album();
        $album->hash = $albumHash;

        if(Auth::user() != null){
            $album->user_id = Auth::user()->id;
        }

        do{
            $imageHash = str_random(7);
        } while (Image::where('hash', $imageHash)->withTrashed()->first() != null);

        $current = Carbon::now();
        $year = $current->year;
        $month = $current->month;
        $day = $current->day;
        $hour = $current->hour;
        $folder = 'uploads/'.$year.'/'.$month.'/'.$day.'/'.$hour;

        if( ! file_exists($folder)) {
            $oldmask = umask(0);
            mkdir($folder, 0775, true);
            mkdir($folder . '/thumb/', 0775, true);
            umask($oldmask);
        }
        $file = $request->file('file');
        $video = $imageHash .'.'. strtolower($file->getClientOriginalExtension());
        $file->move($folder, $video);

        exec('cd '.$folder.' ; ffprobe -v error -of flat=s=_ -select_streams v:0 -show_entries stream=height -of default=noprint_wrappers=1:nokey=1 '.$video, $output, $return);
        $width = 0;
        $scale = "scale=iw:ih:";
        if (0 === $return) {
            foreach ($output as $key) {
                $width = $key;
            }
        }

        exec('cd '.$folder.' ; ffprobe -v error -select_streams v:0 -show_entries stream=duration -of default=noprint_wrappers=1:nokey=1 '.$video, $lengthOutput, $return);
        $length = 0;
        if (0 === $return) {
            foreach ($lengthOutput as $key) {
                $length = (int)$key;
            }
        }

        if($start > $length) {
            $start = $length - $duration;
            if($start < 0)
                $start = 0;
        }

        ob_start();
        if((int)$width == 0 or (int)$length == 0){
            echo "<script>$( '.spinner' ).empty(); $( '#message' ).empty(); $( '#message' ).append( 'Something went wrong while reading the video. File may be damaged.' );</script>";
            @ob_end_flush();
            flush();
            @unlink($folder.'/'.$video);
            return;
        }

        if((int)$width > 600){
            $scale = 'scale=600:-1:';
        }

        exec('cd '.$folder.' ; ffmpeg -y -i '.$video.' -vf fps=10,'.$scale.'flags=lanczos,palettegen '.$imageHash.'_palette.png');
        exec('cd '.$folder.' ; ffmpeg -hide_banner -ss '.$start.' -i '.$video.' -y -i '.$imageHash.'_palette.png -filter_complex "fps=10,'.$scale.'flags=lanczos[x];[x][1:v]paletteuse" -t '.$duration.' '.$imageHash.'.gif');
        echo "<script>$( '.spinner' ).empty(); $( '#message' ).empty(); $( '#message' ).append( 'Video processing completed.' );</script>";
        @ob_end_flush();
        flush();

        $thumbnailName = $imageHash .'.gif';
        try {
            $thumbnailImage = ImgResizer::make($folder . '/'.$thumbnailName)->fit(180, 180);

        } catch(\Intervention\Image\Exception\NotReadableException $e)
        {

            echo "<script>$( '.spinner' ).empty(); $( '#message' ).empty(); $( '#message' ).append( 'Something went wrong while converting video to gif. Video file may be damaged.' );</script>";
            @ob_end_flush();
            flush();
            @unlink($folder.'/'.$video);
            return;
        }

        $thumbnailImage->save( $folder . '/thumb/'. $thumbnailName);
        $album->save();
        $image = new Image();
        $image->hash = $imageHash;
        $image->path = $folder;
        $image->album_id = $album->id;
        $image->extension = 'gif';
        $image->order = 1;

        if(Auth::user() != null){
            $image->user_id = Auth::user()->id;
        }
        $image->save();
        @unlink($folder.'/'.$video);
        echo "<script>window.location.replace('".route('album.show',$album->hash)."');</script>";
        @ob_end_flush();
        flush();
    }

    public function createAlbum(Request $request)
    {
        $albumHash = "";
        $imageHash = "";

        do{
            $albumHash = str_random(7);
        } while (Album::where('hash', $albumHash)->withTrashed()->first() != null);

        $album = new Album();
        $album->hash = $albumHash;

        if(Auth::user() != null){
            $album->user_id = Auth::user()->id;
        }

        if($request->hasFile('file')) {
            $album->save();
            Session::push('album.hash', $album->hash);
            $order = 1;
            foreach($request->file('file') as $file){
                $rules = array('file' => 'required|mimes:png,gif,jpeg,jpg'); //'mimes:png,gif,jpeg,txt,pdf,doc'
                $validator = Validator::make(array('file'=> $file), $rules);

                if($validator->passes()){
                    do{
                        $imageHash = str_random(7);
                    } while (Image::where('hash', $imageHash)->withTrashed()->first() != null);

                    $current = Carbon::now();
                    $year = $current->year;
                    $month = $current->month;
                    $day = $current->day;
                    $hour = $current->hour;
                    $folder = 'uploads/'.$year.'/'.$month.'/'.$day.'/'.$hour;

                    if( ! file_exists($folder)) {
                        $oldmask = umask(0);
                        mkdir($folder, 0775, true);
                        mkdir($folder . '/thumb/', 0775, true);
                        umask($oldmask);
                    }

                    $name = $imageHash .'.'. strtolower($file->getClientOriginalExtension());
                    // echo "name:".$name;
                    $file->move($folder, $name);
                    $thumbnailName = $imageHash .'.'. strtolower($file->getClientOriginalExtension());
                    $thumbnailImage = ImgResizer::make($folder . '/'.$name)->fit(180, 180);
                    $thumbnailImage->save( $folder . '/thumb/'. $thumbnailName);
                    $image = new Image();
                    $image->hash = $imageHash;
                    $image->path = $folder;
                    $image->album_id = $album->id;
                    $image->extension = strtolower($file->getClientOriginalExtension());
                    $image->order = $order;
                    $order = $order + 1;

                    if(Auth::user() != null){
                        $image->user_id = Auth::user()->id;
                    }
                    $image->save();
                }

            }
            echo $album->hash;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, $key)
    {
        $column = 'hash';

        if(\Request::route()->getName() == 'album.slug'){
            $column = 'slug';
        }

        $album = Album::with(array(
            'images' => function ($query) {
                $query->orderBy('order', 'asc');
            }
        ))->with('votes')->with('creator')->where($column, $key)->first();

        if($album == null){
            abort(404, 'The album you are looking for could not be found.');
        }

        $comments = Comment::with('votes')->with('creator')
                            ->where('album_id', $album->id)
                            ->leftJoin('votes', 'votes.votable_id', '=', 'comments.id')
                            ->selectRaw(
                                'comments.*, count(case votes.status when "upvote" then 1 else null end) - count(case votes.status when "downvote" then 1 else null end) as points'
                            )
                           ->selectRaw(
                                'comments.*, count(case votes.status when "neutral" then 1 else null end) as neutral'
                            )
                            ->where('votes.votable_type','App\Models\Comment')
                            ->groupBy('comments.id')
                            ->orderBy('points', 'desc')->orderBy('neutral', 'desc')
                            ->paginate(10);

        if($request->ajax()){
            return [
                'comments' => view('album.comments')->with(compact('comments'))->render(),
                'next_page' => $comments->nextPageUrl()
            ];
        }

        $albums = Album::with(array(
                'images' => function ($query) {
                    $query->orderBy('order', 'asc');
                }
            ))->published()->orderBy('created_at', 'desc')->limit(10)->get();

        $owner = $this->checkIfOwner($album);

        $viewed = Session::get('viewed_albums', []);
        if(in_array($album->hash, $viewed)){
            //do nothing
        } else{
            $album->increment('views');
            Session::push('viewed_albums', $album->hash);
        }

        $options = ReportOptions::orderBy('id', 'asc')->get();
        $tags = Tag::all();
        $tag = null;
        if($album->tag_id)
            $tag = Tag::find($album->tag_id);

        // return view('album.show')->withAlbum($album)->withComments($comments)->withAlbums($albums)->withOwner($owner)->withOptions($options);
        return view('album.show', compact('album', 'comments', 'albums', 'owner', 'options', 'tags', 'tag'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function publish(Request $request)
    {
        $album = Album::where('hash', $request->album)->first();

        $enable_seo_for_published_albums = Setting::where('name', 'enable_seo_for_published_albums')->first();
        if($album->published){
            if($enable_seo_for_published_albums->body == 'yes')
                return redirect()->route('album.slug', [$album->slug]);
            else
                return redirect()->route('album.show', [$album->hash]);
        }

        $owner = $this->checkIfOwner($album);

        if($owner && $album->title != ''){
            $album->title = Purifier::clean($request->title);
            $album->title = trim($album->title);
            $album->title = preg_replace('/[^a-zA-Z0-9\']/', ' ', $album->title);
            $album->title = str_replace("'", '', $album->title);
            $album->title = trim($album->title);
            if($request->topic != 0)
                $album->tag_id = $request->topic;
            if($album->title != ''){
                $album->slug = null;
                $album->save();
            }

            if(strlen($album->title) > 4){
                $album->published = true;
                $album->published_at = Carbon::now();
                $album->privacy = false;
                foreach($album->images as $image){
                    $image->privacy = false;
                    $image->save();
                }
                $album->vote('upvote');
                $album->save();
            } else {
                Session::flash('album.publish', 'Title must be longer then 4 characters.');
                return redirect()->route('album.show', [$album->hash]);
            }
        }
        else{
            Session::flash('album.publish', 'Title can\'t be empty. You can\'t use special characters in the title. Only alphanumeric characters are allowed.');
            return redirect()->route('album.show', [$album->hash]);
        }


        if($enable_seo_for_published_albums->body == 'yes')
            return redirect()->route('album.slug', [$album->slug]);
        else
            return redirect()->route('album.show', [$album->hash]);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function showReorder($hash)
    {

        $album = Album::where('hash', $hash)->first();

        $owner = $this->checkIfOwner($album);

        if($owner){
            try{
                $album = Album::with(array(
                    'images' => function ($query) {
                        $query->orderBy('order', 'asc');
                    }
                ))->where('hash',$hash)->firstOrFail();
            }
            catch(ModelNotFoundException $e){
                return redirect()->route('album.index');
            }

            return view('album.reorder')->withAlbum($album);
        }

        return redirect()->route('album.index');

    }

    public function reorder(Request $request, $hash)
    {

        $album = Album::where('hash', $hash)->first();

        $owner = $this->checkIfOwner($album);

        $ids = $request->ids;
        $order = 1;

        if($owner && !empty($ids)){
            foreach($ids as $id){
                $image = Image::where('id', $id)->first();
                $image->order = $order;
                $image->save();
                $order = $order + 1;
            }
            echo $hash;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        $album = Album::where('hash', $request->album)->first();

        $owner = $this->checkIfOwner($album);

        if($owner){
            if($album){
                $album->reason = "Deleted by user";
                $album->deleted_by = Auth::user()->id;
                $album->save();
                $album->delete();

                return response()->json([
                    'status' => 'success',
                    'msg' => 'Album deleted!',
                ], 201);
            }
        }
    }

    public function getPrivacy(Request $request)
    {
        $album = Album::where('hash', $request->album)->first();
        $owner = $this->checkIfOwner($album);

        if($owner){
            if($album){
                return response()->json([
                    'status' => 'success',
                    'privacy' => $album->privacy,
                ], 201);
            }
        }
        return response()->json([
            'status' => 'error',
            'msg' => 'Problem with getting privacy.',
        ], 401);
    }

    public function setPrivacy(Request $request)
    {
        $album = Album::where('hash', $request->album)->first();
        $owner = $this->checkIfOwner($album);

        if($owner){
            if($album){
                $album->privacy = $request->privacy;
                $album->save();
                foreach($album->images as $image){
                    $image->privacy = $request->privacy;
                    $image->save();
                }
                return response()->json([
                    'status' => 'success',
                    'privacy' => $album->privacy,
                ], 201);
            }
        }
        return response()->json([
            'status' => 'error',
            'msg' => 'Problem with updating privacy.',
        ], 401);
    }
}
