<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Session;
use App\Models\Setting;
use App\Models\myZipArchive;
use Artisan;

class UpdateController extends Controller
{
    public function updateShow()
    {
        $url = "http://code4fun.io/update/check";
        $host = url('/');
        $currentVersion = Setting::where('name', 'version')->first();
        // $currentVersion = config('app.version');

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FAILONERROR, false);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_AUTOREFERER, true);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER,true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'app=imgshare&version='.$currentVersion->body.'&url=a$host');
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $response = curl_exec($ch);
        $json = json_decode($response);
        $update = $json->update;
        $version = $json->version;

        curl_close($ch);

        return view('admin.update.show', compact("update","version","currentVersion"));
    }

    public function update(Request $request)
    {
        $url = "http://code4fun.io/update/imgshare.zip";
        $code = $request->purchase_id;
        $username = $request->username;

        header('X-Accel-Buffering: no');
        header('Content-Encoding: none;');
        echo view('admin.update.progress', compact('routeName'))->render();

        $host = url('/');

        $params = [];
        $params['code'] = $code;
        $params['username'] = $username;
        $params['host'] = $host;
        $version = $request->version;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FAILONERROR, false);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_AUTOREFERER, true);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER,true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'purchase_id='.$code.'&username='.$username.'&url='.$host.'&try=true');
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $response = json_decode(curl_exec($ch));
        curl_close($ch);

        if(!isset($response->error))
        {
            $zipFile = "uploads/update.zip"; // Local Zip File Path
            $zipResource = fopen($zipFile, "w");
            // Get The Zip File From Server
            $ch2 = curl_init();
            curl_setopt($ch2, CURLOPT_URL, $url);
            curl_setopt($ch2, CURLOPT_FAILONERROR, true);
            curl_setopt($ch2, CURLOPT_HEADER, false);
            curl_setopt($ch2, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch2, CURLOPT_AUTOREFERER, true);
            curl_setopt($ch2, CURLOPT_BINARYTRANSFER,true);
            curl_setopt($ch2, CURLOPT_POST, true);
            curl_setopt($ch2, CURLOPT_POSTFIELDS, 'purchase_id='.$code.'&username='.$username.'&url='.$host);
            curl_setopt($ch2, CURLOPT_TIMEOUT, 10);
            curl_setopt($ch2, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch2, CURLOPT_FILE, $zipResource);

            $page = curl_exec($ch2);

            if(!$page) {
                $error = curl_error($ch2);
                echo "Unknown error while updating. " . $error . " Contact support.";
            } else {
                $demo = env('APP_DEMO', false);
                if($demo){
                    echo '<div class="alert alert-success alert-dismissible">';
                    echo '<button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>';
                    echo '<h4><i class="icon fa fa-check"></i> Success!</h4>';
                    echo 'This is a demo so nothing is updated.';
                    echo '</div>';
                } else {
                    curl_close($ch2);
                    $zip = new myZipArchive;
                    $extractPath = "../";
                    /* Clean migrations */
                    $migrations = glob("../database/migrations/{*.php}", GLOB_BRACE);
                    foreach($migrations as $migration){
                         @unlink($migration);
                    }

                    if ($zip->open($zipFile) === TRUE)
                    {
                        ob_start();
                        echo "<script>$( '#message' ).append( 'Unpacking Models and migrations...<br>' );</script>";
                        ob_end_flush();
                        flush();

                        $errors = $zip->extractSubdirTo("../database", "database/");
                        $errors = $zip->extractSubdirTo("../config", "config/");
                        $errors = $zip->extractSubdirTo("../app/Models", "app/Models/");
                        $errorCount = count($errors);

                        if($iconData = $zip->getFromName('composer.json')) {
                            file_put_contents('../composer.json', $iconData);
                        }
                        if($iconData = $zip->getFromName('composer.lock')) {
                            file_put_contents('../composer.lock', $iconData);
                        }
                        if($errorCount > 0){
                            ob_start();
                            echo "<script>$( '#message' ).append( 'There were some errors while unpacking file, contact support.<br>' );</script>";
                            ob_end_flush();
                            flush();
                        }
                        else {
                            ob_start();
                            echo "<script>$( '#message' ).append( 'Running composer installer.<br>' );</script>";
                            ob_end_flush();
                            flush();

                            exec('cd .. ; composer install --no-interaction --no-dev --prefer-dist 2>&1', $out, $status);
                            if (0 === $status) {
                                foreach ($out as $key) {
                                    ob_start();
                                    echo "<script>$( '#message' ).append( '".$key.".<br>' );</script>";
                                    @ob_end_flush();
                                    flush();
                                }

                                ob_start();
                                echo "<script>$( '#message' ).append( 'Running artisan migrate.<br>' );</script>";
                                ob_end_flush();
                                flush();

                                exec('cd .. ; php artisan migrate --force', $migrateout, $migrate);
                                if (0 === $migrate) {
                                    foreach ($migrateout as $key) {
                                        ob_start();
                                        echo "<script>$( '#message' ).append( '".$key.".<br>' );</script>";
                                        @ob_end_flush();
                                        flush();
                                    }

                                    ob_start();
                                    echo "<script>$( '#message' ).append( 'Running UpdateSeeder.<br>' );</script>";
                                    ob_end_flush();
                                    flush();

                                    exec('cd .. ; php artisan db:seed --class=UpdateSeeder --force', $updateout, $update);
                                    if (0 === $update) {
                                        foreach ($updateout as $key) {
                                            ob_start();
                                            echo "<script>$( '#message' ).append( '".$key.".<br>' );</script>";
                                            @ob_end_flush();
                                            flush();
                                        }

                                        $res = $zip->open($zipFile);
                                        if($res  === TRUE){
                                            /* Extract Zip File */
                                            if($zip->extractTo($extractPath) && 0 === $update && 0 === $migrate)
                                            {
                                                $zip->close();
                                                @unlink($zipFile);

                                                $setting = Setting::where('name', 'version')->first();
                                                $setting->body = $version;
                                                $setting->save();
                                                ob_start();
                                                echo "<script>$( '#version_header' ).val( '".$version."' );</script>";
                                                echo "<script>$( '#version_footer' ).val( '".$version."' );</script>";
                                                echo "<script>$( '#message' ).append( '<h3>Done! Successfully updated to version:".$version."</h3><br>' );</script>";
                                                @ob_end_flush();
                                                flush();
                                            }
                                        } else {
                                            ob_start();
                                            echo "<script>$( '#message' ).append( 'Could not open last zip file, something went wrong. Contact support.<br>' );</script>";
                                            @ob_end_flush();
                                            flush();
                                        }
                                    } else {
                                        ob_start();
                                        echo "<script>$( '#message' ).append( 'Update Seeder failed. Contact support.<br>' );</script>";
                                        @ob_end_flush();
                                        flush();
                                    }
                                } else {
                                    ob_start();
                                    echo "<script>$( '#message' ).append( 'Migration failed. Contact support.<br>' );</script>";
                                    @ob_end_flush();
                                    flush();
                                }
                            } else {
                                ob_start();
                                echo "<script>$( '#message' ).append( 'Composer update failed. Contact support.<br>' );</script>";
                                @ob_end_flush();
                                flush();
                            }
                        }
                    } else{
                        ob_start();
                        echo "<script>$( '#message' ).append( 'Could not open zip file, something went wrong. Contact support.<br>' );</script>";
                        @ob_end_flush();
                        flush();
                    }
                }
            }
        } else{
            ob_start();
            echo "<script>$( '#message' ).append( 'Could not update, something went wrong: " . $response->error . ". Contact support.<br>' );</script>";
            @ob_end_flush();
            flush();
        }
    }
}
