<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Tag;
use Session;

class TagController extends Controller
{
    /**
     * Show the tags.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tags = Tag::orderBy('created_at', 'desc')->paginate(25);
        return view('admin.tags.index')->withTags($tags);
    }

    /**
     * Show Add New form.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.tags.create');
    }

    /**
     * Deletes a tag
     *
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('tags.delete', 'This is demo so tags are not actually deleted!');
        } else {
            $tag = Tag::find($request->id);
            $tag->albums()->detach();

            $tag->delete();
            Session::flash('tags.delete', 'Tag has been deleted!');
        }

        return redirect()->route('admin.tags.index');
    }

    /**
     * Create New Tag
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|max:20'
        ]);

        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('tags.create', 'This is demo so tags are not actually created!');
        } else {
            $tag = new Tag();

            $tag->name = $request->name;
            $tag->slug = null;

            $tag->save();
            Session::flash('tags.create', 'Tag has been created!');
        }

        return redirect()->route('admin.tags.index');
    }

    /**
     * Show Add New form.
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|max:20'
        ]);

        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('tags.update', 'This is demo so tags are not actually updated!');
        } else {
            $tag = Tag::find($request->id);

            $tag->name = $request->name;
            $tag->slug = null;

            $tag->save();
            Session::flash('tags.update', 'Tag has been updated!');
        }

        return redirect()->route('admin.tags.index');
    }

    /**
     * Show Add New form.
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tag = Tag::where('id', $id)->first();
        return view('admin.tags.edit')->withTag($tag);
    }
}
