<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Session;
use App\Models\Setting;
use Cache;

class SettingsController extends Controller
{
    public function ads()
    {
        $setting = Setting::where('name', 'ad_unit_top')->first();
        $settings['ad_unit_top'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );
        $setting = Setting::where('name', 'ad_unit_right_1')->first();
        $settings['ad_unit_right_1'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );
        $setting = Setting::where('name', 'ad_unit_right_2')->first();
        $settings['ad_unit_right_2'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );

        $setting = Setting::where('name', 'ad_unit_comments_top')->first();
        $settings['ad_unit_comments_top'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );

        return view('admin.settings.ads')->withSettings($settings);
    }

    public function upload()
    {
        $setting = Setting::where('name', 'max_upload_files')->first();

        $settings['max_upload_files'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );

        $setting = Setting::where('name', 'max_upload_file_size')->first();

        $settings['max_upload_file_size'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );

        return view('admin.settings.upload')->withSettings($settings);
    }

    public function uploadSave(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('settings.save', 'This is demo so settings are not actually saved! ');
        } else {
            Cache::forget('max_upload_files');
            Cache::forget('max_upload_file_size');
            $setting = Setting::where('name', 'max_upload_files')->first();
            $setting->body = $request->input('max_upload_files');
            $setting->save();

            $setting = Setting::where('name', 'max_upload_file_size')->first();
            $setting->body = $request->input('max_upload_file_size');
            $setting->save();
            Session::flash('settings.save', 'Settings successfully saved!');
        }
        return redirect()->route('admin.settings.upload');
    }

    public function seo()
    {
        $setting = Setting::where('name', 'enable_seo_for_published_albums')->first();

        $settings['enable_seo_for_published_albums'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );

        return view('admin.settings.seo')->withSettings($settings);
    }

    public function seoSave(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('settings.save', 'This is demo so settings are not actually saved! ');
        } else {
            Cache::forget('enable_seo_for_published_albums');
            $setting = Setting::where('name', 'enable_seo_for_published_albums')->first();
            $setting->body = $request->input('seo');
            $setting->save();
            Session::flash('settings.save', 'Settings successfully saved!');
        }
        return redirect()->route('admin.settings.seo');
    }

    public function sitemap()
    {
        $setting = Setting::where('name', 'sitemap_cache')->first();

        $settings['sitemap_cache'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );

        return view('admin.settings.sitemap')->withSettings($settings);
    }

    public function sitemapSave(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('settings.save', 'This is demo so settings are not actually saved! ');
        } else {
            $setting = Setting::where('name', 'sitemap_cache')->first();
            $setting->body = $request->input('sitemap_cache');
            $setting->save();
            Session::flash('settings.save', 'Settings successfully saved!');
        }
        return redirect()->route('admin.settings.sitemap');
    }

    public function pagination()
    {
        $setting = Setting::where('name', 'pagination')->first();

        $settings['pagination'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );

        return view('admin.settings.pagination')->withSettings($settings);
    }

    public function paginationSave(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('settings.save', 'This is demo so settings are not actually saved! ');
        } else {
            Cache::forget('pagination');
            $setting = Setting::where('name', 'pagination')->first();
            $setting->body = $request->input('pagination');
            $setting->save();
            Session::flash('settings.save', 'Settings successfully saved!');
        }
        return redirect()->route('admin.settings.pagination');
    }

    public function uploads()
    {
        $setting = Setting::where('name', 'max_files_upload')->first();

        $settings['max_files_upload'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );

        return view('admin.settings.seo')->withSettings($settings);
    }

    public function adsSave(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('settings.save', 'This is demo so settings are not actually saved!');
        } else {
            Cache::forget('ad_unit_top');
            Cache::forget('ad_unit_right_1');
            Cache::forget('ad_unit_right_2');
            Cache::forget('ad_unit_comments_top');
            $setting = Setting::where('name', 'ad_unit_top')->first();
            $setting->body = $request->input('ad_unit_top');
            $setting->save();
            $setting = Setting::where('name', 'ad_unit_right_1')->first();
            $setting->body = $request->input('ad_unit_right_1');
            $setting->save();
            $setting = Setting::where('name', 'ad_unit_right_2')->first();
            $setting->body = $request->input('ad_unit_right_2');
            $setting->save();
            $setting = Setting::where('name', 'ad_unit_comments_top')->first();
            $setting->body = $request->input('ad_unit_comments_top');
            $setting->save();
            Session::flash('settings.save', 'Settings successfully saved!');
        }
        return redirect()->route('admin.settings.ads');
    }

    public function site()
    {
        $setting = Setting::where('name', 'website_name')->first();
        $settings['name'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );
        $setting = Setting::where('name', 'website_title')->first();
        $settings['title'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );
        $setting = Setting::where('name', 'website_email')->first();
        $settings['email'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );
        $setting = Setting::where('name', 'website_description')->first();
        $settings['description'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );
        $setting = Setting::where('name', 'website_keywords')->first();
        $settings['keywords'] = array (
            "value" => $setting->body,
            "description" => $setting->description
        );

        return view('admin.settings.site')->withSettings($settings);
    }

    public function siteSave(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('settings.save', 'This is demo so settings are not actually saved!');
        } else {
            Cache::forget('website_name');
            Cache::forget('website_title');
            Cache::forget('website_description');
            Cache::forget('website_keywords');
            $setting = Setting::where('name', 'website_name')->first();
            $setting->body = $request->input('name');
            $setting->save();
            \Config::write('app', ['name' => $request->input('name') ]);
            $setting = Setting::where('name', 'website_title')->first();
            $setting->body = $request->input('title');
            $setting->save();
            $setting = Setting::where('name', 'website_description')->first();
            $setting->body = $request->input('description');
            $setting->save();
            $setting = Setting::where('name', 'website_keywords')->first();
            $setting->body = $request->input('keywords');
            $setting->save();

            Session::flash('settings.save', 'Settings successfully saved!');
        }
        return redirect()->route('admin.settings.site');
    }

    public function social()
    {
        $setting = Setting::where('name', 'social')->first();
        $settings['social'] = array (
           "value" => $setting->body,
           "description" => $setting->description
        );

        return view('admin.settings.social')->withSettings($settings);
    }

    public function socialSave(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('settings.save', 'This is demo so settings are not actually saved!');
        } else {
            Cache::forget('social');
            $setting = Setting::where('name', 'social')->first();
            $setting->body = $request->input('social');
            $setting->save();
            Session::flash('settings.save', 'Settings successfully saved!');
        }
        return redirect()->route('admin.settings.social');
    }

    public function analytics()
    {
        $setting = Setting::where('name', 'analytics')->first();
        $settings['analytics'] = array (
           "value" => $setting->body,
           "description" => $setting->description
        );

        return view('admin.settings.analytics')->withSettings($settings);
    }

    public function analyticsSave(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('settings.save', 'This is demo so settings are not actually saved!');
        } else {
            Cache::forget('analytics');
            $setting = Setting::where('name', 'analytics')->first();
            $setting->body = $request->input('analytics');
            $setting->save();
            Session::flash('settings.save', 'Settings successfully saved!');
        }
        return redirect()->route('admin.settings.analytics');
    }
}
