<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\RemovalRequest;
use Auth;

class RequestController extends Controller
{
    public function index()
    {
        $requests = RemovalRequest::orderBy('id', 'desc')->paginate(10);

        return view('admin.requests.index')->withRequests($requests);
    }

    public function closed()
    {
        $requests = RemovalRequest::onlyTrashed()->orderBy('deleted_at', 'desc')->paginate(10);

        return view('admin.requests.closed')->withRequests($requests);
    }

    public function show($id)
    {
        $request = RemovalRequest::withTrashed()->find($id);

        return view('admin.requests.show')->withRequest($request);
    }

    public function close(Request $request)
    {
        $removalRequest = RemovalRequest::withTrashed()->find($request->id);

        $removalRequest->action = $request->action;

        if($request->method == 'close')
            $removalRequest->closed_by = Auth::user()->id;

        $removalRequest->save();

        if($request->method == 'close')
            $removalRequest->delete();

        return redirect()->route('admin.requests.open');
    }
}
