<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\ReportOptions;
use Session;

class ReportEditorController extends Controller
{
    public function index()
    {
        $options = ReportOptions::orderBy('id', 'desc')->get();
        return view('admin.reports.editor.index')->withOptions($options);
    }

    public function create()
    {
        return view('admin.reports.editor.create');
    }

    public function add(Request $request)
    {

        $this->validate($request, [
            'name' => 'required|max:35',
            'description' => 'required|max:250',
        ]);
        $demo = env('APP_DEMO', false);
        $option = new ReportOptions();

        $option->name = $request->name;
        $option->description = $request->description;

        if($demo){
            Session::flash('option.created', 'This is a demo so no options will be created!');
        } else {
            $option->save();
            Session::flash('option.created', 'Report option has been created!');
        }

        return redirect()->route('admin.reports.editor');
    }

    public function update(Request $request)
    {

        $this->validate($request, [
            'name' => 'required|max:35',
            'description' => 'required|max:250',
        ]);

        $demo = env('APP_DEMO', false);

        $option = ReportOptions::find($request->id);

        $option->name = $request->name;
        $option->description = $request->description;
        if($demo){
            Session::flash('option.updated', 'This is a demo so no options will be updated!');
        } else {
            $option->save();
            Session::flash('option.updated', 'Report option has been updated!');
        }

        return redirect()->route('admin.reports.editor');
    }

    public function edit($id)
    {
        $report = ReportOptions::find($id);
        // dd($report);
        return view('admin.reports.editor.edit')->withReport($report);
    }

    public function delete(Request $request)
    {
        $demo = env('APP_DEMO', false);

        $option = ReportOptions::find($request->id);

        if($demo){
            Session::flash('option.deleted', 'This is a demo so no options will be deleted!');
        } else {
            $option->delete();
            Session::flash('option.deleted', 'Report option has been deleted!');
        }

        return redirect()->route('admin.reports.editor');
    }
}
