<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\Models\Report;
use App\Models\Album;
use App\Models\Comment;
use App\Models\User;
use Carbon\Carbon;
use Session;
use DB;

class ReportController extends Controller
{
    public function albums()
    {
        $reports = Report::where('reportable_type', 'App\Models\Album')->groupBy('reportable_id')->select('reports.*', DB::raw('count(*) as total_reports'))->orderBy('total_reports', 'desc')->paginate(20);

        return view('admin.reports.albums.index')->withReports($reports);
    }

    public function makeItSo(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('makeitso', 'This is demo so nothing is performed!');
        } else {
            $withUser = null;
            $withAlbum = null;
            $withComment = null;

            // With User
            switch ($request->withUser){
                case 'ban':
                    $user = User::find($request->user);
                    $user->banned_by = Auth::user()->id;
                    $user->banned_at = Carbon::now();
                    $user->reason = $request->reason;
                    $user->save();
                    $withUser = 'user banned, id: ' . $user->id;
                break;

                case 'delete':
                    $request->withAlbum = null;
                    $request->withComment = null;
                    $user = User::find($request->user);
                    $user->deleted_by = Auth::user()->id;
                    $user->reason = $request->reason;
                    $withUser = 'user deleted, id: ' . $user->id;
                    $user->save();
                    $user->delete();
                break;
            }

            // With Album
            switch ($request->withAlbum){
                case 'delete':
                    $album = Album::find($request->reportable_id);
                    $album->deleted_by = Auth::user()->id;
                    $album->reason = $request->reason;
                    $album->save();
                    $withAlbum = 'album deleted, id: ' . $album->id;
                    $album->delete();
                break;

                case 'unpublish':
                    $album = Album::find($request->reportable_id);
                    $album->published = false;
                    $album->unpublished_at = Carbon::now();
                    $album->unpublished_by = Auth::user()->id;
                    $album->reason = $request->reason;
                    $album->save();
                    $withAlbum = 'album unpublished, id: ' . $album->id;
                break;

                case 'mature':
                    $album = Album::find($request->reportable_id);
                    $album->mature = true;
                    $album->reason = 'This is mature album.';
                    $album->save();
                    $withAlbum = 'album set to mature, id: ' . $album->id;
                break;
            }

            // With Comment
            switch ($request->withComment){
                case 'delete':
                    $comment = Comment::find($request->reportable_id);
                    $comment->deleted_by = Auth::user()->id;
                    $comment->reason = $request->reason;
                    $comment->save();
                    $withComment = 'comment deleted, id: ' . $comment->id;
                    $comment->delete();
                break;
            }

            $actions = null;
            if($withUser){
                $actions = $withUser;
            }

            if($withAlbum){
                if($actions != null){
                    $actions .= '|' . $withAlbum;
                }
                else {
                    $actions = $withAlbum;
                }
            }

            if($withComment){
                if($actions != null){
                    $actions .= '|' . $withComment;
                }
                else {
                    $actions = $withComment;
                }
            }

            $reports = Report::where('reportable_id', $request->reportable_id)->get();

            foreach ($reports as $report) {
                $report->resolved_by = Auth::user()->id;
                $report->actions = $actions;
                $report->save();
                $report->delete();
            }
        }

        if($request->action == 'album'){
            return redirect()->route('admin.reports.albums');
        }

        if($request->action == 'comment'){
            return redirect()->route('admin.reports.comments');
        }
    }

    public function albumShow($id)
    {
        $album = Album::with(array(
            'images' => function ($query) {
                $query->orderBy('order', 'asc');
            },
        ))->with('creator')->where('id', $id)->first();

        $report = Report::where('reportable_type', 'App\Models\Album')->select('reports.*', DB::raw('count(*) as total_reports'))->where('reportable_id', $id)->orderBy('total_reports', 'desc')->get();

        return view('admin.reports.albums.show')->withAlbum($album)->withReport($report);
    }

    public function commentShow($id)
    {
        $comment = Comment::with('creator')->where('id', $id)->first();

        $report = Report::where('reportable_type', 'App\Models\Comment')->select('reports.*', DB::raw('count(*) as total_reports'))->where('reportable_id', $id)->orderBy('total_reports', 'desc')->get();

        return view('admin.reports.comments.show')->withComment($comment)->withReport($report);
    }

    public function comments()
    {
        $reports = Report::where('reportable_type', 'App\Models\Comment')->groupBy('reportable_id')->select('reports.*', DB::raw('count(*) as total_reports'))->orderBy('total_reports', 'desc')->orderBy('id', 'desc')->paginate(20);

        return view('admin.reports.comments.index')->withReports($reports);
    }
}
