<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Page;
use Session;

class PageController extends Controller
{
    /**
     * Show the pages.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pages = Page::orderBy('order', 'asc')->paginate(15);
        return view('admin.pages.index')->withPages($pages);
    }

    /**
     * Show the pages.
     *
     * @return \Illuminate\Http\Response
     */
    public function orderShow()
    {
        $pages = Page::orderBy('order', 'asc')->paginate(15);
        return view('admin.pages.order')->withPages($pages);
    }

    /**
     * Show the pages.
     *
     * @return \Illuminate\Http\Response
     */
    public function saveOrder(Request $request)
    {
        $ids = $request->ids;
        $order = 1;

        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('page.order', 'This is demo so page order has not been saved!');
        } else {
            foreach($ids as $id){
                $page = Page::find($id);
                $page->order = $order;
                $page->save();
                $order = $order + 1;
            }
            Session::flash('page.order', 'Page order has been saved!');
        }
    }

    public function show($id)
    {
        $page = Page::where('id', $id)->first();
        return view('admin.pages.show')->withPage($page);
    }

    public function save(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|max:20',
        ]);

        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('page.saved', 'This is demo so nothing is saved!');
        } else {
            $page = Page::find($request->id);
            $page->name = $request->name;
            $page->content = $request->content;
            $page->save();
            Session::flash('page.saved', 'Page has been saved!');
        }

        return redirect()->route('admin.pages.list');
    }
}
