<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\Meme;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use ImgResizer;
use Session;

class MemeController extends Controller
{
    public function index()
    {
        $memes = Meme::orderBy('id', 'desc')->admin()->paginate(20);
        return view('admin.meme.index')->withMemes($memes);
    }

    public function create()
    {
        return view('admin.meme.create');
    }

    public function show($id)
    {
        $meme = Meme::find($id);
        return view('admin.meme.edit')->withMeme($meme);
    }

    public function save(Request $request)
    {
        $this->validate($request, [
            'title' => 'required|numeric|max:160',
            'file' => 'required|mimes:jpeg,bmp,png|dimensions:min_width=600',
            ],
            [
                'file.dimensions'  => 'Mimimum width is 600px.',
            ]
        );

        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('savememe', 'This is demo so memes are not saved!');
        } else {
            if($request->hasFile('file')) {
                $file = $request->file('file');

                $meme = new Meme();
                $meme->title = $request->title;
                $meme->extension = strtolower($file->getClientOriginalExtension());
                $meme->save();
                $name = $meme->slug .'.'. strtolower($file->getClientOriginalExtension());
                $uploadFolder = 'memes/';

                $file->move($uploadFolder, $name);
                $width = ImgResizer::make($uploadFolder.$name)->width();
                $image = ImgResizer::make($uploadFolder.$name);

                if($width > 600){
                  $image->resize(600, null, function ($constraint) {
                      $constraint->aspectRatio();
                  });
                }

                $image->save($uploadFolder.$name);
                $meme->width = $image->width();
                $meme->height = $image->height();
                $meme->save();

                $thumbnailImage = ImgResizer::make($uploadFolder.$name)->fit(220, 220);
                $thumbnailImage->save( $uploadFolder . 'thumb/'. $name);

            }
        }
        return redirect()->route('admin.meme.list');
    }

    public function update(Request $request)
    {
        $this->validate($request, [
            'title' => 'required|numeric|max:160',
            'file' => 'sometimes|mimes:jpeg,bmp,png|dimensions:min_width=600',
            ],
            [
                'file.dimensions'  => 'Mimimum width is 600px.',
            ]
        );

        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('savememe', 'This is demo so memes are not updated!');
        } else {
            $uploadFolder = 'memes/';
            $thumb = 'thumb/';
            if($request->hasFile('file')) {
                $meme = Meme::find($request->id);
                $name = $meme->slug .'.'.$meme->extension;
                @unlink($uploadFolder.$name);
                @unlink($uploadFolder.$thumb.$name);
            }

            $meme = Meme::find($request->id);
            $meme->title = $request->title;
            $oldfile = $meme->slug.'.'.$meme->extension;
            $meme->slug = null;
            $meme->save();
            $newFile = $meme->slug.'.'.$meme->extension;
            @rename($uploadFolder.$oldfile, $uploadFolder.$newFile);
            @rename($uploadFolder.$thumb.$oldfile, $uploadFolder.$thumb.$newFile);

            if($request->hasFile('file')) {
                $file = $request->file('file');
                $meme = Meme::find($request->id);
                $meme->extension = strtolower($file->getClientOriginalExtension());
                $meme->save();
                $name = $meme->slug .'.'. strtolower($file->getClientOriginalExtension());

                @unlink($uploadFolder.$name);
                $file->move($uploadFolder, $name);
                $width = ImgResizer::make($uploadFolder.$name)->width();
                $image = ImgResizer::make($uploadFolder.$name);
                if($width > 600){
                  $image->resize(600, null, function ($constraint) {
                      $constraint->aspectRatio();
                  });
                }
                $image->save($uploadFolder.$name);

                $meme->width = $image->width();
                $meme->height = $image->height();
                $meme->save();

                $thumbnailImage = ImgResizer::make($uploadFolder.$name)->fit(280, 280);
                $thumbnailImage->save( $uploadFolder.$thumb.$name);
            }
        }
        return redirect()->route('admin.meme.list');
    }

    public function delete(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('savememe', 'This is demo so memes are not updated!');
        } else {
            $meme = Meme::find($request->id);
            $uploadFolder = 'memes/';
            $name = $meme->slug .'.'.$meme->extension;
            @unlink($uploadFolder.$name);
            @unlink($uploadFolder.'thumb/'.$name);
            $meme->delete();
        }
        return redirect()->route('admin.meme.list');
    }
}
