<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Image;
use App\Models\Report;
use Carbon\Carbon;
use Auth;
use Session;

class ImageController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $images = Image::orderBy('id', 'desc')->paginate(30);

        return view('admin.images.index')->withImages($images);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $image = Image::with('creator')->where('id',$id)->first();

        return view('admin.images.show')->withImage($image);
    }

    public function makeItSo(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('makeitso', 'This is demo so nothing is performed!');
        } else {

            $withUser = null;
            $withImage = null;

            // With User
            switch ($request->withUser){
                case 'ban':
                    $user = User::find($request->user);
                    $user->action_by = Auth::user()->id;
                    $user->banned_at = Carbon::now();
                    $user->reason = $request->reason;
                    $user->save();
                    $withUser = 'user banned, id: ' . $user->id;
                break;

                case 'delete':
                    $request->withImage = null;
                    $user = User::find($request->user);
                    $user->action_by = Auth::user()->id;
                    $user->reason = $request->reason;
                    $withUser = 'user deleted, id: ' . $user->id;
                    $user->save();
                    $user->delete();
                break;
            }

            // With Image
            switch ($request->withImage){
                case 'delete':
                    $image = Image::find($request->id);
                    $image->deleted_by = Auth::user()->id;
                    $image->reason = $request->reason;
                    $image->save();
                    $withImage = 'image deleted, id: ' . $image->id;
                    $image->delete();
                break;
            }

            $actions = null;
            if($withUser){
                $actions = $withUser;
            }

            if($withImage){
                if($actions != null){
                    $actions .= '|' . $withImage;
                }
                else {
                    $actions = $withImage;
                }
            }

            $reports = Report::where('reportable_id', $request->id)->get();

            foreach ($reports as $report) {
                $report->resolved_by = Auth::user()->id;
                $report->actions = $actions;
                $report->save();
                $report->delete();
            }
        }

        return redirect()->route('admin.image.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        $demo = env('APP_DEMO', false);

        $image = Image::where('id', $request->id)->first();

        if($demo){
            Session::flash('image.deleted', 'This is a demo so no images will be deleted!');
        } else {
            if($image){
                $filename = $image->hash .'.'. $image->extension;
                $thumbnail = '/thumb/'.$image->hash .'.'. $image->extension;
                unlink(public_path($filename));
                unlink(public_path($thumbnail));
                $image->delete();
                Session::flash('image.deleted', 'Image has been deleted!');
            }
        }
        // return redirect()->route('admin.image.index');
    }
}
