<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\Comment;
use App\Models\Report;
use Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;

class CommentController extends Controller
{
    /**
     * Show the comments.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $comments = Comment::orderBy('id', 'desc')->paginate(28);
        return view('admin.comments.index')->withComments($comments);
    }

    /**
     * Show Comment.
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $comment = Comment::where('id', $id)->first();
        return view('admin.comments.show')->withComment($comment);
    }

    public function makeItSo(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('makeitso', 'This is demo so nothing is performed!');
        } else {
            $withUser = null;
            $withComment = null;

            // With User
            switch ($request->withUser){
                case 'ban':
                    $user = User::find($request->user);
                    $user->banned_by = Auth::user()->id;
                    $user->banned_at = Carbon::now();
                    $user->reason = $request->reason;
                    $user->save();
                    $withUser = 'user banned, id: ' . $user->id;
                break;

                case 'delete':
                    $request->withComment = null;
                    $user = User::find($request->user);
                    $user->deleted_by = Auth::user()->id;
                    $user->reason = $request->reason;
                    $withUser = 'user deleted, id: ' . $user->id;
                    $user->save();
                    $user->delete();
                break;
            }

            // With Comment
            switch ($request->withComment){
                case 'delete':
                    $comment = Comment::find($request->reportable_id);
                    $comment->deleted_by = Auth::user()->id;
                    $comment->reason = $request->reason;
                    $comment->save();
                    $withComment = 'comment deleted, id: ' . $comment->id;
                    $comment->delete();
                break;
            }

            $actions = null;
            if($withUser){
                $actions = $withUser;
            }

            if($withComment){
                if($actions != null){
                    $actions .= '|' . $withComment;
                }
                else {
                    $actions = $withComment;
                }
            }

            $reports = Report::where('reportable_id', $request->reportable_id)->get();

            foreach ($reports as $report) {
                $report->resolved_by = Auth::user()->id;
                $report->actions = $actions;
                $report->save();
                $report->delete();
            }
        }

        return redirect()->route('admin.comments.index');

    }
}
