<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use App\Models\Album;
use App\Models\Image;
use App\Models\Report;
use Carbon\Carbon;
use Validator;
use Auth;
use Session;
use Response;
use Illuminate\Database\Eloquent\ModelNotFoundException;
//
class AlbumController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $albums = Album::with(array(
                'images' => function ($query) {
                    $query->orderBy('order', 'asc');
                }
            ))
            ->orderBy('id', 'desc')->paginate(30);

        return view('admin.albums.index')->withAlbums($albums);
        // return view('album.index', compact('albums'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $album = Album::with(array(
            'images' => function ($query) {
                $query->orderBy('order', 'asc');
            }
        ))->with('creator')->where('id',$id)->first();

        return view('admin.albums.show')->withAlbum($album);
    }


    public function makeItSo(Request $request)
    {
        $demo = env('APP_DEMO', false);

        if($demo){
            Session::flash('makeitso', 'This is demo so nothing is performed!');
        } else {
            $withUser = null;
            $withAlbum = null;

            // With User
            switch ($request->withUser){
                case 'ban':
                    $user = User::find($request->user);
                    $user->action_by = Auth::user()->id;
                    $user->banned_at = Carbon::now();
                    $user->reason = $request->reason;
                    $user->save();
                    $withUser = 'user banned, id: ' . $user->id;
                break;

                case 'delete':
                    $request->withAlbum = null;
                    $user = User::find($request->user);
                    $user->action_by = Auth::user()->id;
                    $user->reason = $request->reason;
                    $withUser = 'user deleted, id: ' . $user->id;
                    $user->save();
                    $user->delete();
                break;
            }

            // With Album
            switch ($request->withAlbum){
                case 'delete':
                    $album = Album::find($request->album_id);
                    $album->deleted_by = Auth::user()->id;
                    $album->reason = $request->reason;
                    $album->save();
                    $withAlbum = 'album deleted, id: ' . $album->id;
                    $album->delete();
                break;

                case 'unpublish':
                    $album = Album::find($request->album_id);
                    $album->published = false;
                    $album->unpublished_at = Carbon::now();
                    $album->unpublished_by = Auth::user()->id;
                    $album->reason = $request->reason;
                    $album->save();
                    $withAlbum = 'album unpublished, id: ' . $album->id;
                break;

                case 'mature':
                    $album = Album::find($request->album_id);
                    $album->mature = true;
                    $album->reason = 'This is mature album.';
                    $album->save();
                    $withAlbum = 'album set to mature, id: ' . $album->id;
                break;
            }

            $actions = null;
            if($withUser){
                $actions = $withUser;
            }

            if($withAlbum){
                if($actions != null){
                    $actions .= '|' . $withAlbum;
                }
                else {
                    $actions = $withAlbum;
                }
            }

            $reports = Report::where('reportable_id', $request->album_id)->get();

            foreach ($reports as $report) {
                $report->resolved_by = Auth::user()->id;
                $report->actions = $actions;
                $report->save();
                $report->delete();
            }
        }

        return redirect()->route('admin.album.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {

        $demo = env('APP_DEMO', false);

        $album = Album::where('id', $request->id)->first();
        if($demo){
            Session::flash('album.deleted', 'This is a demo so no albums will be deleted!');
        } else {

            if($album){
                foreach ($album->images as $image){
                    $filename = $image->hash .'.'. $image->extension;
                    $thumbnail = '/thumb/'.$image->hash .'.'. $image->extension;
                    unlink(public_path($filename));
                    unlink(public_path($thumbnail));
                }
                $album->delete();
                Session::flash('album.deleted', 'Album has been deleted!');
            }
        }
        return redirect()->route('admin.album.index');
    }
}
