<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\Album;
use App\Models\Image;
use App\Models\User;
use App\Models\Comment;

use Purifier;

class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    // public function __construct()
    // {
    //     $this->middleware('auth');
    // }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function root()
    {
        return redirect()->route('admin.dashboard');
    }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function dashboard()
    {
        $albumCount = Album::count();
        $imageCount = Image::count();
        $userCount = User::count();
        $commentCount = Comment::count();
        return view('admin.dashboard', compact('albumCount', 'imageCount', 'userCount', 'commentCount'));
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function documentation()
    {
        return view('admin.documentation.show');
    }

}
