<?php

/**
 * @class IconPress__Bb_IconModule
 */
class IconPress__Bb_IconModule extends FLBuilderModule {

    /**
     * Constructor function for the module. You must pass the
     * name, description, dir and url in an array to the parent class.
     *
     * @method __construct
     */
    public function __construct()
    {
        parent::__construct(array(
            'name'          => __('IconPress Icon', 'iconpress'),
            'description'   => __('An example for coding new modules.', 'iconpress'),
            'category'		=> __('IconPress Modules', 'iconpress'),
            'dir'           =>ICONPRESS_BEAVERBUILDER_DIR . 'module_iconpress_icon/',
            'url'           =>ICONPRESS_BEAVERBUILDER_URL . 'module_iconpress_icon/',
            'editor_export' => true,
            'enabled'       => true,
        ));

        /**
         * Use these methods to enqueue css and js already
         * registered or to register and enqueue your own.
         */

        // Register and enqueue your own
        // $this->add_css('example-lib', $this->url . 'css/example-lib.css');
        // $this->add_js('example-lib', $this->url . 'js/example-lib.js', array(), '', true);
    }
}

/**
 * Register the module and its form settings.
 */
FLBuilder::register_module('IconPress__Bb_IconModule', array(
    'general'       => array( // Tab
        'title'         => __( 'General', 'iconpress' ), // Tab title
        'sections'      => array( // Tab Sections
            'general'       => array( // Section
                'title'         => '', // Section Title
                'fields'        => array( // Section Fields
                    'icon'          => array(
                        'type'          => 'iconpress_browse_icon',
                        'default'       => 'iconpress-logo',
                        'label'         => __( 'Icontest', 'iconpress' ),
                    ),
                ),
            ),
            'link'          => array(
                'title'         => __( 'Link', 'iconpress' ),
                'fields'        => array(
                    'link'          => array(
                        'type'          => 'link',
                        'label'         => __( 'Link', 'iconpress' ),
                        'preview'       => array(
                            'type'          => 'none',
                        ),
                        'connections'   => array( 'url' ),
                    ),
                    'link_target'   => array(
                        'type'          => 'select',
                        'label'         => __( 'Link Target', 'iconpress' ),
                        'default'       => '_self',
                        'options'       => array(
                            '_self'         => __( 'Same Window', 'iconpress' ),
                            '_blank'        => __( 'New Window', 'iconpress' ),
                        ),
                        'preview'       => array(
                            'type'          => 'none',
                        ),
                    ),
                ),
            ),

        ),
    ),
    'style'         => array( // Tab
        'title'         => __( 'Style', 'iconpress' ), // Tab title
        'sections'      => array( // Tab Sections
            'colors'        => array( // Section
                'title'         => __( 'Colors', 'iconpress' ), // Section Title
                'fields'        => array( // Section Fields
                    'color'         => array(
                        'type'          => 'color',
                        'label'         => __( 'Color', 'iconpress' ),
                        'show_reset'    => true,
                    ),
                    'hover_color' => array(
                        'type'          => 'color',
                        'label'         => __( 'Hover Color', 'iconpress' ),
                        'show_reset'    => true,
                        'preview'       => array(
                            'type'          => 'none',
                        ),
                    ),
                    'bg_color'      => array(
                        'type'          => 'color',
                        'label'         => __( 'Background Color', 'iconpress' ),
                        'show_reset'    => true,
                    ),
                    'bg_hover_color' => array(
                        'type'          => 'color',
                        'label'         => __( 'Background Hover Color', 'iconpress' ),
                        'show_reset'    => true,
                        'preview'       => array(
                            'type'          => 'none',
                        ),
                    ),
                    'three_d'       => array(
                        'type'          => 'select',
                        'label'         => __( 'Gradient', 'iconpress' ),
                        'default'       => '0',
                        'options'       => array(
                            '0'             => __( 'No', 'iconpress' ),
                            '1'             => __( 'Yes', 'iconpress' ),
                        ),
                    ),
                ),
            ),
            'structure'     => array( // Section
                'title'         => __( 'Structure', 'iconpress' ), // Section Title
                'fields'        => array( // Section Fields
                    'size'          => array(
                        'type'          => 'text',
                        'label'         => __( 'Size', 'iconpress' ),
                        'default'       => '30',
                        'maxlength'     => '3',
                        'size'          => '4',
                        'description'   => 'px',
                        'sanitize'      => 'absint',
                    ),
                    'align'         => array(
                        'type'          => 'select',
                        'label'         => __( 'Alignment', 'iconpress' ),
                        'default'       => 'left',
                        'options'       => array(
                            'center'        => __( 'Center', 'iconpress' ),
                            'left'          => __( 'Left', 'iconpress' ),
                            'right'         => __( 'Right', 'iconpress' ),
                        ),
                    ),
                ),
            ),
            'r_structure'   => array(
                'title'         => __( 'Mobile Structure', 'iconpress' ),
                'fields'        => array(
                    'r_align'       => array(
                        'type'          => 'select',
                        'label'         => __( 'Alignment', 'iconpress' ),
                        'default'       => 'default',
                        'options'       => array(
                            'default'       => __( 'Default', 'iconpress' ),
                            'custom'        => __( 'Custom', 'iconpress' ),
                        ),
                        'toggle'        => array(
                            'custom'        => array(
                                'fields'        => array( 'r_custom_align' ),
                            ),
                        ),
                    ),
                    'r_custom_align'    => array(
                        'type'              => 'select',
                        'label'             => __( 'Custom Alignment', 'iconpress' ),
                        'default'           => 'left',
                        'options'           => array(
                            'left'              => __( 'Left', 'iconpress' ),
                            'center'            => __( 'Center', 'iconpress' ),
                            'right'             => __( 'Right', 'iconpress' ),
                        ),
                    ),
                ),
            ),
        ),
    ),
));
