<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// If Lite is installed
if ( is_plugin_active( 'iconpress-lite/iconpress.php' ) ) {

	add_action( 'admin_notices', function () {
		echo '<div class="notice notice-error">';
		echo '<p>' . __( '<strong>IconPress Lite</strong> has been deactivated because PRO is installing/active.', 'iconpress' ) . '</p>';
		echo '</div>';
	} );

	\deactivate_plugins( 'iconpress-lite/iconpress.php' );
	unset( $_GET['activate'], $_GET['plugin_status'], $_GET['activate-multi'] );
}

//!@++
//#! Load & configure the framework
require( ICONPRESS_DIR . '/ink-framework/index.php' );
\Ink\Framework::getInstance( 'iconpress' )->init( [
	//#! [REQUIRED] Provide the system path to the framework directory
	'ink-dir' => ICONPRESS_DIR . 'ink-framework/',
	//#! [REQUIRED] Provide the uri to the framework directory
	'ink-uri' => ICONPRESS_URI . 'ink-framework/',
	//#! [REQUIRED] Provide the path to the WP_CONTENT directory
	'ink-content-dir' => trailingslashit( WP_CONTENT_DIR ),
	//#! [OPTIONAL] Configure logging
	'logging' => [
		'enable-logging' => true,
		'instance-name' => 'iconpress',
		'log-file-name' => 'iconpress-debug.log',
		'min-logging-level' => \Ink\Helpers\Logger::SYSTEM,
	],
] );

require( ICONPRESS_DIR . 'extend/lib/ip-dash/Base.php' );
require( ICONPRESS_DIR . 'extend/Base.php' );
require( ICONPRESS_DIR . 'extend/lib/helpers/RestAPI.php' );
// IconFinder
require( ICONPRESS_DIR . 'extend/lib/iconfinder/Api.php' );
require( ICONPRESS_DIR . 'extend/lib/iconfinder/Base.php' );
require( ICONPRESS_DIR . 'extend/lib/iconfinder/Options.php' );
require( ICONPRESS_DIR . 'extend/lib/iconfinder/Rest.php' );

add_action( 'rest_api_init', [ '\\IconPress\\Extend\\Base', 'registerRoutes' ], 190 );

add_action( 'admin_init', [ '\\IconPress\\Dashboard\\Base', 'checkStatus' ] );
add_action( 'admin_init', [ '\\IconPress\\Dashboard\\Base', 'checkApiResponse' ] );