<?php

use IconPress\Helpers\FileSystem;
use IconPress\Helpers\RestAPI;
use IconPress\Helpers\Option;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wrap iconpress-page iconpressApp-components">

	<?php
	$helpMenu = [
		[
			'title' => __('Uploading an SVG icon', 'iconpress'),
			'url' => 'https://customers.iconpress.io/kb/uploading-an-svg-icon/'
		]
	];
	include( ICONPRESS_DIR . 'admin/pages/inc/topmenu.inc.php' ); ?>

	<h1 class="iconpress-pageTitle"><?php _e( 'IconPress - Upload Icons', 'iconpress' ); ?></h1>
	<?php
	//#! Check File System access
	FileSystem::checkWpFileSystem();

	?>

	<div class="iconpress-pageSection ip-uploadSection">
		<h2>
			<?php _e( 'Upload icons', 'iconpress' ) ?>
		</h2>

		<h3><?php _e( 'My uploads:', 'iconpress' ); ?></h3>

		<?php
			$saved_collections = get_option( Option::getOptionName( Option::SAVED_COLLECTIONS ), [] );

			$uploaded_items = '';
			if( isset($saved_collections['default']) ) {
				foreach ($saved_collections['default'] as $key => $item) {
					if( $item['type'] == 'upload' ){
						$uploaded_items .= '<li>';
							$uploaded_items .= IconPress__getSvgIcon(array('id' => $item['internal_id']));
							$uploaded_items .= '<span data-id="'. $item['internal_id'] .'" class="ip-uploadedSvgs-delete">×</span>';
						$uploaded_items .= '</li>';
					}
				}
			}

		?>
		<ul class="ip-uploadedSvgs <?php echo !$uploaded_items ? 'is-empty' : '' ?>" id="uploadedSvgs">
			<?php
				echo $uploaded_items;
		 	?>
		</ul>
		<p><?php _e( 'You don\'t have any svg\'s uploaded.', 'iconpress' ); ?></p>


		<div class="ip-uploadSection-actions">
			<button class="ip-btn ip-btn--lined ip-btn--gray js-btn-uploadSvgFiles">
				<?php _e( 'UPLOAD .SVG IMAGE', 'iconpress' ); ?>
			</button>
			 &nbsp;&nbsp;&nbsp;
			<button class="ip-btn ip-btn--lined ip-btn--gray" disabled="disabled">
				<?php _e( 'UPLOAD WEBFONT (Soon!)', 'iconpress' ); ?>
			</button>
		</div>
		<div class="ip-uploadSvgFiles">
			<ul class="ip-u-list">
				<li><?php _e('Currently supporting only simple SVG images, not sprites;', 'iconpress'); ?></li>
				<li><?php _e('The icon\'s file name will be used as title;', 'iconpress'); ?></li>
				<li><?php echo sprintf(  __('These icons you upload can also be found in <a href="%s">My Collection</a> page;', 'iconpress'), admin_url('admin.php?page=iconpress_my_collection') ); ?></li>
			</ul>

			<div class="u-mb-25">
				<input type="checkbox" id="js-uploadMediaLibrary" checked><label for="js-uploadMediaLibrary"><?php _e('Upload SVG to Media Library?', 'iconpress'); ?></label>
			</div>

			<form action="<?php echo rest_url( RestAPI::ICONPRESS_NAMESPACE . 'upload_svg' ); ?>" class="dropzone ip-dropzone" id="js-upload-svg-image">
				<input type="hidden" name="uploadml" value="1">
			</form>
		</div>
	</div>

	<?php
	/*
	@TODO: Soon to be added;
	<div class="iconpress-pageSection ip-otherLibsSection">
		<h2>
			<?php _e( 'Other libraries', 'iconpress' ) ?>
			<p class="ip-comingSoon"><?php _e( 'COMING SOON IN PRO VERSION', 'iconpress' ); ?></p>
		</h2>
		<p><?php _e( 'No icon library yet.', 'iconpress' ); ?></p>

	</div>
	*/
?>
</div>
