<?php
	/*
	* =======================================================================
	* CLASSNAME:        upload_class.php
	* DATE CREATED:  	11-11-2013
	* FOR TABLE:  		admin_users
	* PRODUCED BY:		HEZECOM UltimateSpeed PHP CODE GENERATOR
	* AUTHOR:			Hezecom (http://hezecom.com) info@hezecom.net
	* =======================================================================
	*/
	if(!defined('VALID_DIR')) die('You are not allowed to execute this file directly');
	
	class UploadControl{
	
	//IMAGE UPLOAD AND RESIZE
	function ImageResize($hWidth,$hHeight,$MaxSize,$ToFolder,$SrcImage,$quality,$ImageType)
	{
	if($hWidth <= 0 || $hHeight <= 0) {return false;}
	//size of new image
	$ImageScale = min($MaxSize/$hWidth, $MaxSize/$hHeight); 
	$NewWidth = ceil($ImageScale*$hWidth);
	$NewHeight = ceil($ImageScale*$hHeight);
	$NewCanves = imagecreatetruecolor($NewWidth, $NewHeight);
	imagesavealpha($NewCanves, true); 
	$color = imagecolorallocatealpha($NewCanves,0x00,0x00,0x00,127); 
	imagefill($NewCanves, 0, 0, $color);
	// Resize Image
	if(imagecopyresampled($NewCanves, $SrcImage,0, 0, 0, 0, $NewWidth, $NewHeight, $hWidth, $hHeight))
	{
	switch(strtolower($ImageType)){
	case 'image/png': imagepng($NewCanves,$ToFolder);break;
	case 'image/gif': imagegif($NewCanves,$ToFolder);break;			
	case 'image/jpeg':
	case 'image/pjpeg': imagejpeg($NewCanves,$ToFolder,$quality);break;
	default: return false;
	}
	if(is_resource($NewCanves)) {imagedestroy($NewCanves);} 
	return true;
	}}
	//corps image 
	function ImageCrop($hWidth,$hHeight,$iSize,$ToFolder,$SrcImage,$quality,$ImageType)
	{	 
	if($hWidth <= 0 || $hHeight <= 0) {return false;}
	if($hWidth>$hHeight){$y_offset = 0;$x_offset = ($hWidth - $hHeight) / 2;
	$square_size 	= $hWidth - ($x_offset * 2);
	}else{
	$x_offset = 0;$y_offset = ($hHeight - $hWidth) / 2;$square_size = $hHeight - ($y_offset * 2);
	}
	$NewCanves 	= imagecreatetruecolor($iSize, $iSize);
	imagesavealpha($NewCanves, true); 
	$color = imagecolorallocatealpha($NewCanves,0x00,0x00,0x00,127); 
	imagefill($NewCanves, 0, 0, $color);	
	if(imagecopyresampled($NewCanves, $SrcImage,0, 0, $x_offset, $y_offset, $iSize, $iSize, $square_size, $square_size))
	{
	switch(strtolower($ImageType)){
	case 'image/png':imagepng($NewCanves,$ToFolder);break;
	case 'image/gif':imagegif($NewCanves,$ToFolder);break;			
	case 'image/jpeg':
	case 'image/pjpeg':imagejpeg($NewCanves,$ToFolder,$quality);break;
	default: return false;
	}
	if(is_resource($NewCanves)) {imagedestroy($NewCanves);} 
	return true;
	}
	}

	function ImageUplaodResize($dfile,$thumbsize,$imgsize,$path_main,$path_thumb,$quality){
	if(isset($_POST) and $_FILES[$dfile]['name']!='')
	{
	if(!isset($_FILES[$dfile]) || !is_uploaded_file($_FILES[$dfile]['tmp_name']))
	{die('Something went wrong with Upload!');}
	// Random number
	$randnum = rand(0, 9999999999); 
	$ImageName = str_replace(' ','-',strtolower($_FILES[$dfile]['name'])); 
	$ImageSize = $_FILES[$dfile]['size'];
	$TempSrc = $_FILES[$dfile]['tmp_name'];
	$ImageType = $_FILES[$dfile]['type'];
	switch(strtolower($ImageType)){
	case 'image/png': $CreatedImage = imagecreatefrompng($_FILES[$dfile]['tmp_name']);break;
	case 'image/gif': $CreatedImage = imagecreatefromgif($_FILES[$dfile]['tmp_name']);break;			
	case 'image/jpeg':
	case 'image/pjpeg': $CreatedImage = imagecreatefromjpeg($_FILES[$dfile]['tmp_name']);break;
	default: die('Unsupported File Format!');
	}
	list($hWidth,$hHeight)=getimagesize($TempSrc);
	$ImageExt = substr($ImageName, strrpos($ImageName, '.'));
  	$ImageExt = str_replace('.','',$ImageExt);
	$ImageName 		= preg_replace("/\\.[^.\\s]{3,4}$/", "", $ImageName); 
	$NewImageName = $randnum.'.'.$ImageExt;
	//img path
	$paththumb 	= $path_thumb.$NewImageName; //Thumb
	$pathfull 	= $path_main.$NewImageName; //Main Image
	//Resize
	if($this->ImageResize($hWidth,$hHeight,$imgsize,$pathfull,$CreatedImage,$quality,$ImageType))
	{
	if(!$this->ImageCrop($hWidth,$hHeight,$thumbsize,$paththumb,$CreatedImage,$quality,$ImageType))
	{echo 'Error Creating Thumbnail';}

	return $NewImageName;
		
	}else{
		die('Image Resize Error'); //output error
	}
	}

	}//end

}//end class
?>