<?php
	/*
	Hezecom Email Solution
	Author: Hezecom Technologies (http://hezecom.com) info@hezecom.net
	COPYRIGHT 2014 ALL RIGHTS RESERVED
	
	You must have purchased a valid license from CodeCanyon.com in order to have 
	access this file.

	You may only use this file according to the respective licensing terms 
	you agreed to when purchasing this item.
	*/
	session_start();
	include('config/config.php');
	include('language/eng.php');
	include('libraries/functions.php');
	include('libraries/url_writer.php');
	
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><?php echo H_TITLE;?></title>
<link href='http://fonts.googleapis.com/css?family=Frijole' rel='stylesheet' type='text/css'>
<link rel="stylesheet" type="text/css" href="<?php echo H_THEME;?>/css/bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="<?php echo H_THEME;?>/css/font-awesome.min.css">
<link href="<?php echo H_THEME;?>/css/style.css" rel="stylesheet">
<script src="<?php echo H_THEME;?>/js/modernizr.custom.js"></script>
</head>
<body>
  	<div class="container">
    <div class="row">
    <?php if(get('act')=='signup'){?>
    <p>
    <div class="col-md-6 col-md-offset-3">
<form action="libraries/process_reg.php" id="msgSend" method="post" class="form" role="form" enctype="multipart/form-data">   

<legend><?php echo LANG_SIGN_UP;?></legend>

<div id="output"></div>

<div class="row">
<div class="col-xs-6 col-md-6">
<input type="text" class="form-control input-lg" value="<?php echo post('fname');?>" name="fname" id="fname" placeholder="<?php echo LANG_FIRST_NAME;?>" required>                        
</div>
<div class="col-xs-6 col-md-6">
<input type="text" class="form-control input-lg" name="lname" value="<?php echo post('lname');?>" id="lname" placeholder="<?php echo LANG_LAST_NAME;?>" required>                        
</div>
</div>


<div class="row">
<div class="col-xs-6 col-md-6">
<input name="username" type="text" class="form-control input-lg" id='username' maxlength="15" placeholder="<?php echo LANG_CHOOSE_USERNAME;?>" required>
</div> 
<div class="col-xs-6 col-md-6">
 <input type="button" id="check_username_availability" value="<?php echo LANG_AVAILABILITY;?>" class="btn btn-info btn-sm">
 <span>@<?php echo C_URL;?></span>
 <div id='username_availability_result'></div>
</div>
</div>

<input type="password" class="form-control input-lg" name="pwd" id="pwd" placeholder="<?php echo LANG_ENTER_PASSWORD;?>" onKeyUp="PwdStrength(this.value)" required>
<input type="password" name="pwd2" value="" class="form-control input-lg" placeholder="<?php echo LANG_CONFIRM_PASSWORD;?>" required/> 
<div id="PwdDescription"></div>
<div id="PwdStrength" class="strength0"></div><br>
   
                    
<label><?php echo LANG_BITHDAY;?></label>                    

<div class="row">

<div class="col-xs-4 col-md-4">
<select name="month" class = "form-control input-lg">
<option value="0"><?php echo LANG_MONTH;?></option><?php echo generate_options(1,12,'callback_month')?></select>
</select> 
</div>

<div class="col-xs-4 col-md-4">
<select name="day" class = "form-control input-lg">
 <option value="0"><?php echo LANG_DAY;?></option><?php echo generate_options(1,31)?></select>
</select>
</div>

<div class="col-xs-4 col-md-4">
<select name="year" class = "form-control input-lg">
<option value="0"><?php echo LANG_YEAR;?></option><?php echo generate_options(date('Y'),1900)?></select>
</div>
</div>

<input type="text" class="form-control input-lg numbersOnly" name="phone" id="phone" placeholder="<?php echo LANG_PHONE;?>">
<input type="email" class="form-control input-lg" name="email" placeholder="<?php echo LANG_ALTERNATE_EMAIL;?>" required>

<label><?php echo LANG_GENDER;?> </label>                    
<label class="radio-inline">
<input type="radio" name="gender" value="<?php echo LANG_MALE;?>" id=male /> <?php echo LANG_MALE;?>
</label>
<label class="radio-inline">
<input type="radio" name="gender" value="<?php echo LANG_FEMALE;?>" id=female /><?php echo LANG_FEMALE;?>
</label>

<div class="control-group">
<select name="location" id="location" class="form-control input-lg choz">
<option value=""><?php echo LANG_SELECT_LOCATION;?></option>
<?php include('libraries/views/countries.html');?>
</select>
</div><br />

<div class="row">
<div class="col-xs-7 col-md-7">

<div id="hezecom-wraper">
<div class="btn btn-info" style="font-size:18px; font-family: 'Frijole', Arial, serif;"><?php echo captcha_validation(7); ?> <input name="captcha" type="text" maxlength="20"  placeholder="<?php echo LANG_VERIFICATION_CODE;?>"  autocomplete="off" />
</div>
</div>
</div>
<div class="col-xs-3 col-md-3" style="position:absolute; margin-top:10px; right:370px;">
<a id="refresh" href="#" class="btn btn-info" title="<?php echo LANG_REFRESH; ?>"><i class="fa fa-refresh"></i></a>                      
</div>
</div><br />



<div class="control-group">
<input name="submit" type="submit" class="btn btn-lg btn-primary btn-block" id="msgButton" value="<?php echo LANG_CREATE_NEW_ACCOUNT; ?>">
</div>

</form> 
</p>         
</div>
</div>
 
<?php }elseif(get('act')=='lostpwd'){?>
 <div class="col-md-6 col-md-offset-3">
<form action="libraries/lostpwd_process.php" method="post" class="form" id="msgSend" role="form" enctype="multipart/form-data">   

<legend><?php echo LANG_LOST_PASSWORD_TITLE;?></legend>

<div id="output"></div>


<div class="form-group">
<input type="email" class="form-control input-lg"  name="email" id="email" placeholder="<?php echo LANG_ALTERNATE_EMAIL;?>" />
</div>

<div class="control-group">
<input name="button" type="submit" class="btn btn-lg btn-primary btn-block signup-btn" id="msgButton"  value="<?php echo LANG_RETRIEVE_PASSWORD;?>">
</div>
<a href="<?php echo $login;?>" class="text-center new-account"><?php echo LANG_GO_BACK;?> </a>
</form>          
</div>
 
</div>

<?php }else{?>
        <div class="col-sm-6 col-md-4 col-md-offset-4">
            <h1 class="text-center login-title"></h1><?php echo LANG_LONGIN_TITLE; ?></h1>
            <div class="account-wall">
            <span class="fa fa-user profile-img" style="color:#CCC; font-size:100px;"></span>
            
<form class="form-signing" role="form" id="msgSend" method="post" action="libraries/login.php">
<input type="text" class="form-control" name="username" placeholder="Email" required autofocus>
<input type="password" class="form-control" name="password" placeholder="Password" required>
<button class="btn btn-lg btn-primary btn-block " name="submit" type="submit"  id="msgButton"> <?php echo LANG_SIGN_IN;?></button>

 <a href="<?php echo $lp_url;?>" class="pull-right need-help"><?php echo LANG_LOST_YOUR_PASSWORD;?> </a><span class="clearfix"></span>
                
                <div id="output"></div>
                </form>
            </div>
            <a href="<?php echo $sign_url;?>" class="text-center new-account"><?php echo LANG_CREATE_ACCOUNT;?> </a>
        </div>
        <?php }?>
    </div>
</div>
<script src='<?php echo H_THEME;?>/js/jquery.js'></script>
<script src="<?php echo H_THEME;?>/js/bootstrap.min.js"></script>
<script src="<?php echo H_THEME;?>/js/jquery.form.js"></script>
<script src="<?php echo H_THEME;?>/js/hezecom.custom.js"></script>
  </body>
  </html>
