(function (b) {
    function a(d, c) {
        this.el = d;
        this.$el = b(this.el);
        this.options = b.extend({
            color: "#f7f7f7",
            units: "",
            icon: 0,
            label_selector: ".vc_pie_chart_value",
            back_selector: ".vc_pie_chart_back",
            responsive: true
        }, c);
        this.init()
    }

    a.prototype = {
        constructor: a, _progress_v: 0, animated: false, init: function () {
            this.color = this.options.color;
            this.value = this.$el.data("pie-value") / 100;
            this.label_value = this.$el.data("pie-label-value") || this.$el.data("pie-value");
            this.$wrapper = b(".vc_pie_wrapper", this.$el);
            this.$label = b(this.options.label_selector, this.$el);
            this.$back = b(this.options.back_selector, this.$el);
            this.$canvas = this.$el.find("canvas");
            this.draw();
            this.setWayPoint();
            if (true === this.options.responsive) {
                this.setResponsive()
            }
        }, setResponsive: function () {
            var c = this;
            b(window).resize(function () {
                if (true === c.animated) {
                    c.circle.stop()
                }
                c.draw(true)
            })
        }, draw: function (f) {
            var d = this.$el.addClass("vc_ready").width(), e = 4.5, c;
            if (!d) {
                d = this.$el.parents(":visible").first().width() - 2
            }
            d = d / 100 * 80;
            c = d / 2 - e - 0.5;
            this.$wrapper.css({width: d + "px"});
            this.$label.css({width: d, height: d, "line-height": d + "px"});
            this.$back.css({width: d, height: d});
            this.$canvas.attr({width: d + "px", height: d + "px"});
            this.$el.addClass("vc_ready");
            this.circle = new ProgressCircle({canvas: this.$canvas.get(0), minRadius: c, arcWidth: e});
            if (true === f && true === this.animated) {
                this._progress_v = this.value;
                this.circle.addEntry({fillColor: this.color, progressListener: b.proxy(this.setProgress, this)}).start()
            }
        }, setProgress: function () {
            if (this._progress_v >= this.value) {
                this.circle.stop();
                if (this.options.icon == "0") {
                    this.$label.text(this.label_value + this.options.units)
                }
                return this._progress_v
            }
            this._progress_v += 0.005;
            var c = this._progress_v / this.value * this.label_value;
            var d = Math.round(c) + this.options.units;
            if (this.options.icon == "0") {
                this.$label.text(d)
            }
            return this._progress_v
        }, animate: function () {
            if (true !== this.animated) {
                this.animated = true;
                this.circle.addEntry({
                    fillColor: this.color,
                    progressListener: b.proxy(this.setProgress, this)
                }).start(5)
            }
        }, setWayPoint: function () {
            if ("undefined" !== typeof(b.fn.waypoint)) {
                this.$el.waypoint(b.proxy(this.animate, this), {offset: "85%"})
            } else {
                this.animate()
            }
        }
    };
    b.fn.vcChat = function (c, d) {
        return this.each(function () {
            var g = b(this), f = g.data("vc_chart"), e = "object" === typeof(c) ? c : {
                color: g.data("pie-color"),
                units: g.data("pie-units"),
                icon: g.data("pie-icon")
            };
            if ("undefined" === typeof(c)) {
                g.data("vc_chart", (f = new a(this, e)))
            }
            if ("string" === typeof(c)) {
                f[c](d)
            }
        })
    };
    if ("function" !== typeof(window.vc_pieChart)) {
        window.vc_pieChart = function () {
            b(".vc_pie_chart:visible").vcChat()
        }
    }
    b(document).ready(function () {
        !window.vc_iframe && vc_pieChart()
    })
})(window.jQuery);
(function (e, b, f) {
    var a = function (g) {
        var i, h;
        i = h = 0;
        if (g.offsetParent) {
            do {
                i += g.offsetLeft;
                h += g.offsetTop
            } while (g = g.offsetParent)
        }
        return [i, h]
    };
    var c = function (g) {
        this.canvas = g.canvas;
        this.minRadius = g.minRadius || 15;
        this.arcWidth = g.arcWidth || 5;
        this.gapWidth = g.gapWidth || 3;
        this.centerX = g.centerX || this.canvas.width / 2;
        this.centerY = g.centerY || this.canvas.height / 2;
        this.infoLineLength = g.infoLineLength || 60;
        this.horizLineLength = g.horizLineLength || 10;
        this.infoLineAngleInterval = g.infoLineAngleInterval || Math.PI / 8;
        this.infoLineBaseAngle = g.infoLineBaseAngle || Math.PI / 6;
        this.context = this.canvas.getContext("2d");
        this.width = this.canvas.width;
        this.height = this.canvas.height;
        this.circles = [];
        this.runningCount = 0
    };
    c.prototype = {
        constructor: c, addEntry: function (g) {
            this.circles.push(new d({
                canvas: this.canvas,
                context: this.context,
                centerX: this.centerX,
                centerY: this.centerY,
                innerRadius: this.minRadius + this.circles.length * (this.gapWidth + this.arcWidth),
                arcWidth: this.arcWidth,
                infoLineLength: this.infoLineLength,
                horizLineLength: this.horizLineLength,
                id: this.circles.length,
                fillColor: g.fillColor,
                outlineColor: g.outlineColor,
                progressListener: g.progressListener,
                infoListener: g.infoListener,
                infoLineAngle: this.infoLineBaseAngle + this.circles.length * this.infoLineAngleInterval,
            }));
            return this
        }, start: function (h) {
            var g = this;
            this.timer = setInterval(function () {
                g._update()
            }, h || 33);
            return this
        }, update: function (g) {
            this._update(g)
        }, stop: function () {
            clearTimeout(this.timer)
        }, _update: function (g) {
            this._clear();
            this.circles.forEach(function (i, h, j) {
                i.update(g)
            });
            return this
        }, _clear: function () {
            this.context.clearRect(0, 0, this.canvas.width, this.canvas.height);
            return this
        },
    };
    var d = function (m) {
        this.id = m.id;
        this.canvas = m.canvas;
        this.context = m.context;
        this.centerX = m.centerX;
        this.centerY = m.centerY;
        this.arcWidth = m.arcWidth;
        this.innerRadius = m.innerRadius || 0;
        this.fillColor = m.fillColor || "#fff";
        this.outlineColor = m.outlineColor || this.fillColor;
        this.progressListener = m.progressListener;
        this.infoLineLength = m.infoLineLength || 250;
        this.horizLineLength = m.horizLineLength || 50;
        this.infoListener = m.infoListener;
        this.infoLineAngle = m.infoLineAngle;
        this.outerRadius = this.innerRadius + this.arcWidth;
        if (!this.infoListener) {
            return
        }
        var l = this.infoLineAngle, j = (this.innerRadius + this.outerRadius) / 2, h = Math.sin(l), i = Math.cos(l);
        this.infoLineStartX = this.centerX + h * j;
        this.infoLineStartY = this.centerY - i * j;
        this.infoLineMidX = this.centerX + h * this.infoLineLength;
        this.infoLineMidY = this.centerY - i * this.infoLineLength;
        this.infoLineEndX = this.infoLineMidX + (h < 0 ? -this.horizLineLength : this.horizLineLength);
        this.infoLineEndY = this.infoLineMidY;
        var k = b.createElement("div"), g = k.style;
        g.color = this.fillColor;
        g.position = "absolute";
        g.left = this.infoLineEndX + a(this.canvas)[0] + "px";
        k.className = "ProgressCircleInfo";
        k.id = "progress_circle_info_" + this.id;
        b.body.appendChild(k);
        this.infoText = k
    };
    d.prototype = {
        constructor: d, update: function (g) {
            this.progress = g || this.progressListener();
            this._draw();
            if (this.infoListener) {
                this.info = this.infoListener();
                this._drawInfo()
            }
        }, _draw: function () {
            var h = this.context, j = -Math.PI / 2, k = 0 + j, i = k + this.progress * Math.PI * 2, g = this.centerX, n = this.centerY, m = this.innerRadius, l = this.outerRadius;
            h.fillStyle = this.fillColor;
            h.strokeStyle = this.outlineColor;
            h.beginPath();
            h.arc(g, n, m, k, i, false);
            h.arc(g, n, l, i, k, true);
            h.closePath();
            h.stroke();
            h.fill();
            return this
        }, _drawInfo: function () {
            var g, h;
            g = [[this.infoLineStartX, this.infoLineStartY], [this.infoLineMidX, this.infoLineMidY], [this.infoLineEndX, this.infoLineEndY],];
            this._drawSegments(g, false);
            this.infoText.innerHTML = this.info;
            h = this.infoText.offsetHeight;
            this.infoText.style.top = this.infoLineEndY + a(this.canvas)[1] - h / 2 + "px";
            return this
        }, _drawSegments: function (g, k) {
            var h = this.context;
            h.beginPath();
            h.moveTo(g[0][0], g[0][1]);
            for (var j = 1; j < g.length; ++j) {
                h.lineTo(g[j][0], g[j][1])
            }
            if (k) {
                h.closePath()
            }
            h.stroke()
        },
    };
    e.ProgressCircle = c
})(window, document);