<?php
/**
 * GravityView preset template
 *
 * @file class-gravityview-preset-profiles.php
 * @package   GravityView
 * @license   GPL2+
 * @author    Katz Web Services, Inc.
 * @link      http://gravityview.co
 * @copyright Copyright 2015, Katz Web Services, Inc.
 *
 * @since 1.15
 */

class GravityView_Preset_Profiles extends GravityView_Default_Template_List {

	function __construct() {

		$id = 'preset_profiles';

		$settings = array(
			'slug'          => 'list',
			'type'          => 'preset',
			'label'         => __( 'People Profiles', 'gravityview' ),
			'description'   => __( 'List people with individual profiles.', 'gravityview' ),
			'logo'          => plugins_url( 'includes/presets/profiles/logo-profiles.png', GRAVITYVIEW_FILE ),
			'preview'       => 'http://demo.gravityview.co/blog/view/people-profiles/',
			'preset_form'   => GRAVITYVIEW_DIR . 'includes/presets/profiles/form-profiles.xml',
			'preset_fields' => GRAVITYVIEW_DIR . 'includes/presets/profiles/fields-profiles.xml'
		);

		parent::__construct( $id, $settings );

	}
}

new GravityView_Preset_Profiles;
