/*
 * Lightcase - jQuery Plugin
 * The smart and flexible Lightbox Plugin.
 *
 * @author		Cornel Boppart <cornel@bopp-art.com>
 * @copyright	Author
 *
 * @version		2.3.6 (20/12/2016)
 */

(function(c){var a={cache:{},support:{},objects:{},init:function(a){return this.each(function(){c(this).unbind("click.lightcase").bind("click.lightcase",function(b){b.preventDefault();c(this).lightcase("start",a)})})},start:function(b){a.origin=lightcase.origin=this;a.settings=lightcase.settings=c.extend(!0,{idPrefix:"lightcase-",classPrefix:"lightcase-",attrPrefix:"lc-",transition:"elastic",transitionIn:null,transitionOut:null,cssTransitions:!0,speedIn:250,speedOut:250,maxWidth:800,maxHeight:500,
forceWidth:!1,forceHeight:!1,liveResize:!0,fullScreenModeForMobile:!0,mobileMatchExpression:/(iphone|ipod|ipad|android|blackberry|symbian)/,disableShrink:!1,shrinkFactor:.75,overlayOpacity:.9,slideshow:!1,slideshowAutoStart:!0,timeout:5E3,swipe:!0,useKeys:!0,useCategories:!0,navigateEndless:!0,closeOnOverlayClick:!0,title:null,caption:null,showTitle:!0,showCaption:!0,showSequenceInfo:!0,inline:{width:"auto",height:"auto"},ajax:{width:"auto",height:"auto",type:"get",dataType:"html",data:{}},iframe:{width:800,
height:500,frameborder:0},flash:{width:400,height:205,wmode:"transparent"},video:{width:400,height:225,poster:"",preload:"auto",controls:!0,autobuffer:!0,autoplay:!0,loop:!1},attr:"data-rel",href:null,type:null,typeMapping:{image:"jpg,jpeg,gif,png,bmp",flash:"swf",video:"mp4,mov,ogv,ogg,webm",iframe:"html,php",ajax:"json,txt",inline:"#"},errorMessage:function(){return'<p class="'+a.settings.classPrefix+'error">'+a.settings.labels.errorMessage+"</p>"},labels:{errorMessage:"Source could not be found...",
"sequenceInfo.of":" of ",close:"Close","navigator.prev":"Prev","navigator.next":"Next","navigator.play":"Play","navigator.pause":"Pause"},markup:function(){c("body").append(a.objects.overlay=c('<div id="'+a.settings.idPrefix+'overlay"></div>'),a.objects.loading=c('<div id="'+a.settings.idPrefix+'loading" class="'+a.settings.classPrefix+'icon-spin"></div>'),a.objects["case"]=c('<div id="'+a.settings.idPrefix+'case" aria-hidden="true" role="dialog"></div>'));a.objects["case"].after(a.objects.nav=c('<div id="'+
a.settings.idPrefix+'nav"></div>'));a.objects.nav.append(a.objects.close=c('<a href="#" class="'+a.settings.classPrefix+'icon-close"><span>'+a.settings.labels.close+"</span></a>"),a.objects.prev=c('<a href="#" class="'+a.settings.classPrefix+'icon-prev"><span>'+a.settings.labels["navigator.prev"]+"</span></a>").hide(),a.objects.next=c('<a href="#" class="'+a.settings.classPrefix+'icon-next"><span>'+a.settings.labels["navigator.next"]+"</span></a>").hide(),a.objects.play=c('<a href="#" class="'+a.settings.classPrefix+
'icon-play"><span>'+a.settings.labels["navigator.play"]+"</span></a>").hide(),a.objects.pause=c('<a href="#" class="'+a.settings.classPrefix+'icon-pause"><span>'+a.settings.labels["navigator.pause"]+"</span></a>").hide());a.objects["case"].append(a.objects.content=c('<div id="'+a.settings.idPrefix+'content"></div>'),a.objects.info=c('<div id="'+a.settings.idPrefix+'info"></div>'));a.objects.content.append(a.objects.contentInner=c('<div class="'+a.settings.classPrefix+'contentInner"></div>'));a.objects.info.append(a.objects.sequenceInfo=
c('<div id="'+a.settings.idPrefix+'sequenceInfo"></div>'),a.objects.title=c('<h4 id="'+a.settings.idPrefix+'title"></h4>'),a.objects.caption=c('<p id="'+a.settings.idPrefix+'caption"></p>'))},onInit:{},onStart:{},onFinish:{},onClose:{},onCleanup:{}},b,a.origin.data?a.origin.data("lc-options"):{});a._callHooks(a.settings.onInit);a.objectData=a._setObjectData(this);a._cacheScrollPosition();a._watchScrollInteraction();a._addElements();a._open();a.dimensions=a.getViewportDimensions()},get:function(b){return a.objects[b]},
getObjectData:function(){return a.objectData},_setObjectData:function(b){b=c(b);b={title:a.settings.title||b.attr(a._prefixAttributeName("title"))||b.attr("title"),caption:a.settings.caption||b.attr(a._prefixAttributeName("caption"))||b.children("img").attr("alt"),url:a._determineUrl(),requestType:a.settings.ajax.type,requestData:a.settings.ajax.data,requestDataType:a.settings.ajax.dataType,rel:b.attr(a._determineAttributeSelector()),type:a.settings.type||a._verifyDataType(a._determineUrl()),isPartOfSequence:a._isPartOfSequence(b.attr(a.settings.attr),
":"),isPartOfSequenceWithSlideshow:a._isPartOfSequence(b.attr(a.settings.attr),":slideshow"),currentIndex:c(a._determineAttributeSelector()).index(b),sequenceLength:c(a._determineAttributeSelector()).length};b.sequenceInfo=b.currentIndex+1+a.settings.labels["sequenceInfo.of"]+b.sequenceLength;b.prevIndex=b.currentIndex-1;b.nextIndex=b.currentIndex+1;return b},_prefixAttributeName:function(b){return"data-"+a.settings.attrPrefix+b},_determineLinkTarget:function(){return a.settings.href||c(a.origin).attr(a._prefixAttributeName("href"))||
c(a.origin).attr("href")},_determineAttributeSelector:function(){var b=c(a.origin),d="";"undefined"!==typeof a.cache.selector?d=a.cache.selector:!0===a.settings.useCategories&&b.attr(a._prefixAttributeName("categories"))?(b=b.attr(a._prefixAttributeName("categories")).split(" "),c.each(b,function(b,c){0<b&&(d+=",");d+="["+a._prefixAttributeName("categories")+'~="'+c+'"]'})):d="["+a.settings.attr+'="'+b.attr(a.settings.attr)+'"]';return a.cache.selector=d},_determineUrl:function(){var b=a._verifyDataUrl(a._determineLinkTarget()),
d=0,f=0,g;c.each(b,function(b,c){a._devicePixelRatio()>=c.density&&c.density>=f&&a._matchMedia()("screen and (min-width:"+c.width+"px)").matches&&c.width>=d&&(d=c.width,f=c.density,g=c.url)});return g},_normalizeUrl:function(a){var b=/^\d+$/;return a.split(",").map(function(a){var d={width:0,density:0};a.trim().split(/\s+/).forEach(function(a,c){if(0===c)return d.url=a;var f=a.substring(0,a.length-1),e=a[a.length-1],g=parseInt(f,10),m=parseFloat(f);"w"===e&&b.test(f)?d.width=g:"h"===e&&b.test(f)?
d.height=g:"x"!==e||isNaN(m)||(d.density=m)});return d})},_isPartOfSequence:function(b,d){var f=c("["+a.settings.attr+'="'+b+'"]');return(new RegExp(d)).test(b)&&1<f.length},isSlideshowEnabled:function(){return a.objectData.isPartOfSequence&&(!0===a.settings.slideshow||!0===a.objectData.isPartOfSequenceWithSlideshow)},_loadContent:function(){a.cache.originalObject&&a._restoreObject();a._createObject()},_createObject:function(){var b;switch(a.objectData.type){case "image":b=c(new Image);b.attr({src:a.objectData.url,
alt:a.objectData.title});break;case "inline":b=c('<div class="'+a.settings.classPrefix+'inlineWrap"></div>');b.html(a._cloneObject(c(a.objectData.url)));c.each(a.settings.inline,function(d,c){b.attr(a._prefixAttributeName(d),c)});break;case "ajax":b=c('<div class="'+a.settings.classPrefix+'inlineWrap"></div>');c.each(a.settings.ajax,function(d,c){"data"!==d&&b.attr(a._prefixAttributeName(d),c)});break;case "flash":b=c('<embed src="'+a.objectData.url+'" type="application/x-shockwave-flash"></embed>');
c.each(a.settings.flash,function(a,c){b.attr(a,c)});break;case "video":b=c("<video></video>");b.attr("src",a.objectData.url);c.each(a.settings.video,function(a,c){b.attr(a,c)});break;default:b=c("<iframe></iframe>"),b.attr({src:a.objectData.url}),c.each(a.settings.iframe,function(a,c){b.attr(a,c)})}a._addObject(b);a._loadObject(b)},_addObject:function(b){a.objects.contentInner.html(b);a._loading("start");a._callHooks(a.settings.onStart);!0===a.settings.showSequenceInfo&&a.objectData.isPartOfSequence?
(a.objects.sequenceInfo.html(a.objectData.sequenceInfo),a.objects.sequenceInfo.show()):(a.objects.sequenceInfo.empty(),a.objects.sequenceInfo.hide());!0===a.settings.showTitle&&void 0!==a.objectData.title&&""!==a.objectData.title?(a.objects.title.html(a.objectData.title),a.objects.title.show()):(a.objects.title.empty(),a.objects.title.hide());!0===a.settings.showCaption&&void 0!==a.objectData.caption&&""!==a.objectData.caption?(a.objects.caption.html(a.objectData.caption),a.objects.caption.show()):
(a.objects.caption.empty(),a.objects.caption.hide())},_loadObject:function(b){switch(a.objectData.type){case "inline":c(a.objectData.url)?a._showContent(b):a.error();break;case "ajax":c.ajax(c.extend({},a.settings.ajax,{url:a.objectData.url,type:a.objectData.requestType,dataType:a.objectData.requestDataType,data:a.objectData.requestData,success:function(d,c,g){"json"===a.objectData.requestDataType?a.objectData.data=d:b.html(d);a._showContent(b)},error:function(b,c,g){a.error()}}));break;case "flash":a._showContent(b);
break;case "video":"function"===typeof b.get(0).canPlayType||0===a.objects["case"].find("video").length?a._showContent(b):a.error();break;default:a.objectData.url?(b.on("load",function(){a._showContent(b)}),b.on("error",function(){a.error()})):a.error()}},error:function(){a.objectData.type="error";var b=c('<div class="'+a.settings.classPrefix+'inlineWrap"></div>');b.html(a.settings.errorMessage);a.objects.contentInner.html(b);a._showContent(a.objects.contentInner)},_calculateDimensions:function(b){a._cleanupDimensions();
var d={objectWidth:b.attr("width")?b.attr("width"):b.attr(a._prefixAttributeName("width")),objectHeight:b.attr("height")?b.attr("height"):b.attr(a._prefixAttributeName("height"))};if(!a.settings.disableShrink)switch(d.maxWidth=parseInt(a.dimensions.windowWidth*a.settings.shrinkFactor),d.maxHeight=parseInt(a.dimensions.windowHeight*a.settings.shrinkFactor),d.maxWidth>a.settings.maxWidth&&(d.maxWidth=a.settings.maxWidth),d.maxHeight>a.settings.maxHeight&&(d.maxHeight=a.settings.maxHeight),d.differenceWidthAsPercent=
parseInt(100/d.maxWidth*d.objectWidth),d.differenceHeightAsPercent=parseInt(100/d.maxHeight*d.objectHeight),a.objectData.type){case "image":case "flash":case "video":100<d.differenceWidthAsPercent&&d.differenceWidthAsPercent>d.differenceHeightAsPercent&&(d.objectWidth=d.maxWidth,d.objectHeight=parseInt(d.objectHeight/d.differenceWidthAsPercent*100));100<d.differenceHeightAsPercent&&d.differenceHeightAsPercent>d.differenceWidthAsPercent&&(d.objectWidth=parseInt(d.objectWidth/d.differenceHeightAsPercent*
100),d.objectHeight=d.maxHeight);100<d.differenceHeightAsPercent&&d.differenceWidthAsPercent<d.differenceHeightAsPercent&&(d.objectWidth=parseInt(d.maxWidth/d.differenceHeightAsPercent*d.differenceWidthAsPercent),d.objectHeight=d.maxHeight);break;case "error":!isNaN(d.objectWidth)&&d.objectWidth>d.maxWidth&&(d.objectWidth=d.maxWidth);break;default:(isNaN(d.objectWidth)||d.objectWidth>d.maxWidth)&&!a.settings.forceWidth&&(d.objectWidth=d.maxWidth),(isNaN(d.objectHeight)&&"auto"!==d.objectHeight||d.objectHeight>
d.maxHeight)&&!a.settings.forceHeight&&(d.objectHeight=d.maxHeight)}a.settings.forceWidth?d.maxWidth=d.objectWidth:b.attr(a._prefixAttributeName("max-width"))&&(d.maxWidth=b.attr(a._prefixAttributeName("max-width")));a.settings.forceHeight?d.maxHeight=d.objectHeight:b.attr(a._prefixAttributeName("max-height"))&&(d.maxHeight=b.attr(a._prefixAttributeName("max-height")));a._adjustDimensions(b,d)},_adjustDimensions:function(b,d){b.css({width:d.objectWidth,height:d.objectHeight,"max-width":d.maxWidth,
"max-height":d.maxHeight});a.objects.contentInner.css({width:b.outerWidth(),height:b.outerHeight(),"max-width":"100%"});a.objects["case"].css({width:a.objects.contentInner.outerWidth()});a.objects["case"].css({"margin-top":parseInt(-(a.objects["case"].outerHeight()/2)),"margin-left":parseInt(-(a.objects["case"].outerWidth()/2))})},_loading:function(b){"start"===b?(a.objects["case"].addClass(a.settings.classPrefix+"loading"),a.objects.loading.show()):"end"===b&&(a.objects["case"].removeClass(a.settings.classPrefix+
"loading"),a.objects.loading.hide())},getViewportDimensions:function(){return{windowWidth:c(window).innerWidth(),windowHeight:c(window).innerHeight()}},_verifyDataUrl:function(b){if(!b||void 0===b||""===b)return!1;-1<b.indexOf("#")&&(b=b.split("#"),b="#"+b[b.length-1]);return a._normalizeUrl(b.toString())},_verifyDataType:function(b){var d=a.settings.typeMapping;if(!b)return!1;for(var c in d)if(d.hasOwnProperty(c))for(var g=d[c].split(","),e=0;e<g.length;e++){var m=g[e].toLowerCase(),k=new RegExp(".("+
m+")$","i"),h=b.toLowerCase().split("?")[0].substr(-5);if(!0===k.test(h)||"inline"===c&&-1<b.indexOf(m))return c}return"iframe"},_addElements:function(){"undefined"!==typeof a.objects["case"]&&c("#"+a.objects["case"].attr("id")).length||a.settings.markup()},_showContent:function(b){a.objects["case"].attr(a._prefixAttributeName("type"),a.objectData.type);a.cache.object=b;a._calculateDimensions(b);a._callHooks(a.settings.onFinish);switch(a.settings.transitionIn){case "scrollTop":case "scrollRight":case "scrollBottom":case "scrollLeft":case "scrollHorizontal":case "scrollVertical":a.transition.scroll(a.objects["case"],
"in",a.settings.speedIn);a.transition.fade(a.objects.contentInner,"in",a.settings.speedIn);break;case "elastic":1>a.objects["case"].css("opacity")&&(a.transition.zoom(a.objects["case"],"in",a.settings.speedIn),a.transition.fade(a.objects.contentInner,"in",a.settings.speedIn));case "fade":case "fadeInline":a.transition.fade(a.objects["case"],"in",a.settings.speedIn);a.transition.fade(a.objects.contentInner,"in",a.settings.speedIn);break;default:a.transition.fade(a.objects["case"],"in",0)}a._loading("end");
a.isBusy=!1},_processContent:function(){a.isBusy=!0;switch(a.settings.transitionOut){case "scrollTop":case "scrollRight":case "scrollBottom":case "scrollLeft":case "scrollVertical":case "scrollHorizontal":a.objects["case"].is(":hidden")?(a.transition.fade(a.objects["case"],"out",0,0,function(){a._loadContent()}),a.transition.fade(a.objects.contentInner,"out",0)):a.transition.scroll(a.objects["case"],"out",a.settings.speedOut,function(){a._loadContent()});break;case "fade":a.objects["case"].is(":hidden")?
a.transition.fade(a.objects["case"],"out",0,0,function(){a._loadContent()}):a.transition.fade(a.objects["case"],"out",a.settings.speedOut,0,function(){a._loadContent()});break;case "fadeInline":case "elastic":a.objects["case"].is(":hidden")?a.transition.fade(a.objects["case"],"out",0,0,function(){a._loadContent()}):a.transition.fade(a.objects.contentInner,"out",a.settings.speedOut,0,function(){a._loadContent()});break;default:a.transition.fade(a.objects["case"],"out",0,0,function(){a._loadContent()})}},
_handleEvents:function(){a._unbindEvents();a.objects.nav.children().not(a.objects.close).hide();a.isSlideshowEnabled()&&(!0!==a.settings.slideshowAutoStart&&!a.isSlideshowStarted||a.objects.nav.hasClass(a.settings.classPrefix+"paused")?a._stopTimeout():a._startTimeout());a.settings.liveResize&&a._watchResizeInteraction();a.objects.close.click(function(b){b.preventDefault();a.close()});!0===a.settings.closeOnOverlayClick&&a.objects.overlay.css("cursor","pointer").click(function(b){b.preventDefault();
a.close()});!0===a.settings.useKeys&&a._addKeyEvents();if(a.objectData.isPartOfSequence&&(a.objects.nav.attr(a._prefixAttributeName("ispartofsequence"),!0),a.objects.nav.data("items",a._setNavigation()),a.objects.prev.click(function(b){b.preventDefault();!0!==a.settings.navigateEndless&&a.item.isFirst()||(a.objects.prev.unbind("click"),a.cache.action="prev",a.objects.nav.data("items").prev.click(),a.isSlideshowEnabled()&&a._stopTimeout())}),a.objects.next.click(function(b){b.preventDefault();!0!==
a.settings.navigateEndless&&a.item.isLast()||(a.objects.next.unbind("click"),a.cache.action="next",a.objects.nav.data("items").next.click(),a.isSlideshowEnabled()&&a._stopTimeout())}),a.isSlideshowEnabled()&&(a.objects.play.click(function(b){b.preventDefault();a._startTimeout()}),a.objects.pause.click(function(b){b.preventDefault();a._stopTimeout()})),!0===a.settings.swipe)){if(c.isPlainObject(c.event.special.swipeleft))a.objects["case"].on("swipeleft",function(b){b.preventDefault();a.objects.next.click();
a.isSlideshowEnabled()&&a._stopTimeout()});if(c.isPlainObject(c.event.special.swiperight))a.objects["case"].on("swiperight",function(b){b.preventDefault();a.objects.prev.click();a.isSlideshowEnabled()&&a._stopTimeout()})}},_addKeyEvents:function(){c(document).bind("keyup.lightcase",function(b){if(!a.isBusy)switch(b.keyCode){case 27:a.objects.close.click();break;case 37:a.objectData.isPartOfSequence&&a.objects.prev.click();break;case 39:a.objectData.isPartOfSequence&&a.objects.next.click()}})},_startTimeout:function(){a.isSlideshowStarted=
!0;a.objects.play.hide();a.objects.pause.show();a.cache.action="next";a.objects.nav.removeClass(a.settings.classPrefix+"paused");a.timeout=setTimeout(function(){a.objects.nav.data("items").next.click()},a.settings.timeout)},_stopTimeout:function(){a.objects.play.show();a.objects.pause.hide();a.objects.nav.addClass(a.settings.classPrefix+"paused");clearTimeout(a.timeout)},_setNavigation:function(){var b=c(a.cache.selector||a.settings.attr),d=a.objectData.sequenceLength-1,f={prev:b.eq(a.objectData.prevIndex),
next:b.eq(a.objectData.nextIndex)};0<a.objectData.currentIndex?a.objects.prev.show():f.prevItem=b.eq(d);a.objectData.nextIndex<=d?a.objects.next.show():f.next=b.eq(0);!0===a.settings.navigateEndless&&(a.objects.prev.show(),a.objects.next.show());return f},item:{isFirst:function(){return 0===a.objectData.currentIndex},isLast:function(){return a.objectData.currentIndex===a.objectData.sequenceLength-1}},_cloneObject:function(b){var d=b.clone(),c=b.attr("id");b.is(":hidden")?(a._cacheObjectData(b),b.attr("id",
a.settings.idPrefix+"temp-"+c).empty()):d.removeAttr("id");return d.show()},isMobileDevice:function(){return navigator.userAgent.toLowerCase().match(a.settings.mobileMatchExpression)?!0:!1},isTransitionSupported:function(){var b=c("body").get(0),d=!1,f={transition:"",WebkitTransition:"-webkit-",MozTransition:"-moz-",OTransition:"-o-",MsTransition:"-ms-"},g;for(g in f)f.hasOwnProperty(g)&&g in b.style&&(a.support.transition=f[g],d=!0);return d},transition:{fade:function(b,d,c,g,e){var f="in"===d;d=
{};var k=b.css("opacity"),h={};if(a.isOpen||!f)d.opacity=k,h.opacity=g?g:f?1:0,b.css(d).show(),a.support.transitions?(h[a.support.transition+"transition"]=c+"ms ease",setTimeout(function(){b.css(h);setTimeout(function(){b.css(a.support.transition+"transition","");!e||!a.isOpen&&f||e()},c)},15)):(b.stop(),b.animate(h,c,e))},scroll:function(b,d,c,g){var e="in"===d;d=e?a.settings.transitionIn:a.settings.transitionOut;var f="left",k={},h=e?"-50%":"50%",n={},l=e?"50%":"-50%";if(a.isOpen||!e){switch(d){case "scrollTop":f=
"top";break;case "scrollRight":h=e?"150%":"50%";l=e?"50%":"150%";break;case "scrollBottom":f="top";h=e?"150%":"50%";l=e?"50%":"150%";break;case "scrollHorizontal":h=e?"150%":"50%";l=e?"50%":"-50%";break;case "scrollVertical":f="top",h=e?"-50%":"50%",l=e?"50%":"150%"}if("prev"===a.cache.action)switch(d){case "scrollHorizontal":h=e?"-50%":"50%";l=e?"50%":"150%";break;case "scrollVertical":h=e?"150%":"50%",l=e?"50%":"-50%"}k.opacity=e?0:1;k[f]=h;n.opacity=e?1:0;n[f]=l;b.css(k).show();a.support.transitions?
(n[a.support.transition+"transition"]=c+"ms ease",setTimeout(function(){b.css(n);setTimeout(function(){b.css(a.support.transition+"transition","");!g||!a.isOpen&&e||g()},c)},15)):(b.stop(),b.animate(n,c,g))}},zoom:function(b,d,c,g){var e="in"===d;d={};var f=b.css("opacity"),k={},h=e?"scale(1)":"scale(0.75)";if(a.isOpen||!e)d.opacity=f,d[a.support.transition+"transform"]=e?"scale(0.75)":"scale(1)",k.opacity=e?1:0,b.css(d).show(),a.support.transitions?(k[a.support.transition+"transform"]=h,k[a.support.transition+
"transition"]=c+"ms ease",setTimeout(function(){b.css(k);setTimeout(function(){b.css(a.support.transition+"transform","");b.css(a.support.transition+"transition","");!g||!a.isOpen&&e||g()},c)},15)):(b.stop(),b.animate(k,c,g))}},_callHooks:function(b){"object"===typeof b&&c.each(b,function(b,c){"function"===typeof c&&c.call(a.origin)})},_cacheObjectData:function(b){c.data(b,"cache",{id:b.attr("id"),content:b.html()});a.cache.originalObject=b},_restoreObject:function(){var b=c('[id^="'+a.settings.idPrefix+
'temp-"]');b.attr("id",c.data(a.cache.originalObject,"cache").id);b.html(c.data(a.cache.originalObject,"cache").content)},resize:function(){a.isOpen&&(a.isSlideshowEnabled()&&a._stopTimeout(),a.dimensions=a.getViewportDimensions(),a._calculateDimensions(a.cache.object))},_cacheScrollPosition:function(){var b=c(window),d=c(document),f=b.scrollTop(),g=b.scrollLeft();a.cache.scrollPosition=a.cache.scrollPosition||{};a._assertContentInvisible()?a.cache.cacheScrollPositionSkipped?(delete a.cache.cacheScrollPositionSkipped,
a._restoreScrollPosition()):(d.width()>b.width()&&(a.cache.scrollPosition.left=g),d.height()>b.height()&&(a.cache.scrollPosition.top=f)):a.cache.cacheScrollPositionSkipped=!0},_watchResizeInteraction:function(){c(window).resize(a.resize)},_unwatchResizeInteraction:function(){c(window).off("resize",a.resize)},_watchScrollInteraction:function(){c(window).scroll(a._cacheScrollPosition);c(window).resize(a._cacheScrollPosition)},_unwatchScrollInteraction:function(){c(window).off("scroll",a._cacheScrollPosition);
c(window).off("resize",a._cacheScrollPosition)},_assertContentInvisible:function(){return 0<c(c("body").children().not("[id*="+a.settings.idPrefix+"]").get(0)).height()},_restoreScrollPosition:function(){c(window).scrollTop(parseInt(a.cache.scrollPosition.top)).scrollLeft(parseInt(a.cache.scrollPosition.left)).resize()},_switchToFullScreenMode:function(){a.settings.shrinkFactor=1;a.settings.overlayOpacity=1;c("html").addClass(a.settings.classPrefix+"fullScreenMode")},_open:function(){a.isOpen=!0;
a.support.transitions=a.settings.cssTransitions?a.isTransitionSupported():!1;a.support.mobileDevice=a.isMobileDevice();a.support.mobileDevice&&(c("html").addClass(a.settings.classPrefix+"isMobileDevice"),a.settings.fullScreenModeForMobile&&a._switchToFullScreenMode());a.settings.transitionIn||(a.settings.transitionIn=a.settings.transition);a.settings.transitionOut||(a.settings.transitionOut=a.settings.transition);switch(a.settings.transitionIn){case "fade":case "fadeInline":case "elastic":case "scrollTop":case "scrollRight":case "scrollBottom":case "scrollLeft":case "scrollVertical":case "scrollHorizontal":a.objects["case"].is(":hidden")&&
(a.objects.close.css("opacity",0),a.objects.overlay.css("opacity",0),a.objects["case"].css("opacity",0),a.objects.contentInner.css("opacity",0));a.transition.fade(a.objects.overlay,"in",a.settings.speedIn,a.settings.overlayOpacity,function(){a.transition.fade(a.objects.close,"in",a.settings.speedIn);a._handleEvents();a._processContent()});break;default:a.transition.fade(a.objects.overlay,"in",0,a.settings.overlayOpacity,function(){a.transition.fade(a.objects.close,"in",0);a._handleEvents();a._processContent()})}c("html").addClass(a.settings.classPrefix+
"open");a.objects["case"].attr("aria-hidden","false")},close:function(){a.isOpen=!1;a.isSlideshowEnabled()&&(a._stopTimeout(),a.isSlideshowStarted=!1,a.objects.nav.removeClass(a.settings.classPrefix+"paused"));a.objects.loading.hide();a._unbindEvents();a._unwatchResizeInteraction();a._unwatchScrollInteraction();c("html").removeClass(a.settings.classPrefix+"open");a.objects["case"].attr("aria-hidden","true");a.objects.nav.children().hide();a._restoreScrollPosition();a._callHooks(a.settings.onClose);
switch(a.settings.transitionOut){case "fade":case "fadeInline":case "scrollTop":case "scrollRight":case "scrollBottom":case "scrollLeft":case "scrollHorizontal":case "scrollVertical":a.transition.fade(a.objects["case"],"out",a.settings.speedOut,0,function(){a.transition.fade(a.objects.overlay,"out",a.settings.speedOut,0,function(){a.cleanup()})});break;case "elastic":a.transition.zoom(a.objects["case"],"out",a.settings.speedOut,function(){a.transition.fade(a.objects.overlay,"out",a.settings.speedOut,
0,function(){a.cleanup()})});break;default:a.cleanup()}},_unbindEvents:function(){a.objects.overlay.unbind("click");c(document).unbind("keyup.lightcase");a.objects["case"].unbind("swipeleft").unbind("swiperight");a.objects.prev.unbind("click");a.objects.next.unbind("click");a.objects.play.unbind("click");a.objects.pause.unbind("click");a.objects.close.unbind("click")},_cleanupDimensions:function(){var b=a.objects.contentInner.css("opacity");a.objects["case"].css({width:"",height:"",top:"",left:"",
"margin-top":"","margin-left":""});a.objects.contentInner.removeAttr("style").css("opacity",b);a.objects.contentInner.children().removeAttr("style")},cleanup:function(){a._cleanupDimensions();a.objects.loading.hide();a.objects.overlay.hide();a.objects["case"].hide();a.objects.prev.hide();a.objects.next.hide();a.objects.play.hide();a.objects.pause.hide();a.objects["case"].removeAttr(a._prefixAttributeName("type"));a.objects.nav.removeAttr(a._prefixAttributeName("ispartofsequence"));a.objects.contentInner.empty().hide();
a.objects.info.children().empty();a.cache.originalObject&&a._restoreObject();a._callHooks(a.settings.onCleanup);a.cache={}},_matchMedia:function(){return window.matchMedia||window.msMatchMedia},_devicePixelRatio:function(){return window.devicePixelRatio||1},_isPublicMethod:function(b){return"function"===typeof a[b]&&"_"!==b.charAt(0)},_export:function(){window.lightcase={};c.each(a,function(b){a._isPublicMethod(b)&&(lightcase[b]=a[b])})}};a._export();c.fn.lightcase=function(b){if(a._isPublicMethod(b))return a[b].apply(this,
Array.prototype.slice.call(arguments,1));if("object"!==typeof b&&b)c.error("Method "+b+" does not exist on jQuery.lightcase");else return a.init.apply(this,arguments)}})(jQuery);