<?php
if (!defined('ABSPATH')) {
	exit;
//	Exit if accessed directly
}
if (!class_exists('G5P_Widget_Posts')) {
	class G5P_Widget_Posts extends GSF_Widget
	{
		public function __construct()
		{
			$this->widget_cssclass = 'widget-posts';
			$this->widget_id = 'gsf-posts';
			$this->widget_name = esc_html__('G5Plus: Posts', 'ruby-build-framework');

			$this->settings = array(
				'fields' => array(
					array(
						'id'      => 'title',
						'title'   => esc_html__('Title:', 'ruby-build-framework'),
						'type'    => 'text',
						'default' => '',
					),
					array(
						'id'      => 'layout_style',
						'type'    => 'image_set',
						'title'   => esc_html__('Layout Style', 'ruby-build-framework'),
						'default' => 'small-image',
						'options' => array(
							'post-carousel'         => array(
								'label' => esc_html__('Carousel', 'ruby-build-framework'),
								'img'   => G5P()->pluginUrl('assets/images/theme-options/widget-post-carousel.png'),
							),
							'small-image' => array(
								'label' => esc_html__('Small Image', 'ruby-build-framework'),
								'img'   => G5P()->pluginUrl('assets/images/theme-options/widget-post-small-image.png'),
							),
						)
					),
					array(
						'id'      => 'source',
						'type'    => 'select',
						'title'   => esc_html__('Source', 'ruby-build-framework'),
						'default' => 'recent',
						'options' => array(
							'random'   => esc_html__('Random', 'ruby-build-framework'),
							'popular'  => esc_html__('Popular', 'ruby-build-framework'),
							'recent'   => esc_html__('Recent', 'ruby-build-framework'),
							'oldest'   => esc_html__('Oldest', 'ruby-build-framework'),
							'video'    => esc_html__('Video', 'ruby-build-framework'),
						),
					),
					array(
						'id'         => 'posts_per_page',
						'type'       => 'text',
						'input_type' => 'number',
						'title'      => esc_html__('Number of posts to show:', 'ruby-build-framework'),
						'default'    => '4',
					),
					array(
						'id'      => 'css_animation',
						'type'    => 'select',
						'title'   => esc_html__('CSS Animation', 'ruby-build-framework'),
						'default' => '',
						'options' => G5P()->settings()->get_animation(true),
					),
				)
			);
			parent::__construct();
		}

		function widget($args, $instance)
		{
			extract($args, EXTR_SKIP);
			$title = (!empty($instance['title'])) ? $instance['title'] : '';
			$title = apply_filters('widget_title', $title, $instance, $this->id_base);
			$layout_style = (!empty($instance['layout_style'])) ? $instance['layout_style'] : 'carousel';
			$source = (!empty($instance['source'])) ? $instance['source'] : 'recent';
			$posts_per_page = (!empty($instance['posts_per_page'])) ? absint($instance['posts_per_page']) : 4;
			$css_animation = (!empty($instance['css_animation'])) ? $instance['css_animation'] : '';

			$query_args = array(
				'posts_per_page'      => $posts_per_page,
				'no_found_rows'       => true,
				'post_status'         => 'publish',
				'ignore_sticky_posts' => true,
				'post_type'           => 'post',
				'tax_query'           => array(
					array(
						'taxonomy' => 'post_format',
						'field'    => 'slug',
						'terms'    => array('post-format-link', 'post-format-quote', 'post-format-audio'),
						'operator' => 'NOT IN'
					),
				)
			);

			$query_order_args = array();
			switch ($source) {
				case 'random' :
					$query_order_args = array(
						'orderby' => 'rand',
						'order'   => 'DESC',
					);
					break;
				case 'popular':
					$query_order_args = array(
						'orderby' => 'comment_count',
						'order'   => 'DESC',
					);
					break;
				case 'recent':
					$query_order_args = array(
						'orderby' => 'post_date',
						'order'   => 'DESC',
					);
					break;
				case 'oldest':
					$query_order_args = array(
						'orderby' => 'post_date',
					);
					break;
				case 'video':
					$query_order_args = array(
						'tax_query' => array(
							array(
								'taxonomy' => 'post_format',
								'field'    => 'slug',
								'terms'    => array('post-format-video'),
								'operator' => 'IN'
							),
						)
					);
					break;
			}

			$query_args = array_merge($query_args, $query_order_args);

			if (!function_exists('g5plusRubyBuild')) return;
			$settings = array(
				'post_layout' => $layout_style,
				'post_paging' => 'none',
			);
			if ($css_animation !== '') {
				$settings['post_animation'] = $css_animation;
			}

			$query_settings = array();
			switch ($layout_style) {
				case 'post-carousel' :
					$query_settings = array(
						'carousel'       => array(
							'items'      => 1,
							'loop'       => false,
							'autoHeight' => true,
							'dots'       => false,
							'nav'        => true,
						),
						'carousel_class' => 'nav-top-right',
					);
					break;
			}
			$settings = array_merge($settings, $query_settings);

			echo wp_kses_post($args['before_widget']);
			if ($title):
				echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
			endif;
            g5plusRubyBuild()->blog()->archive_markup($query_args, $settings);
			echo wp_kses_post($args['after_widget']);
		}
	}
}
