<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
if (!class_exists('G5P_Widget_Logo')) {
	class G5P_Widget_Logo extends  GSF_Widget
	{
		public function __construct() {
			$this->widget_cssclass    = 'widget-logo';
			$this->widget_id          = 'gsf-logo';
			$this->widget_name        = esc_html__( 'G5Plus: Logo', 'ruby-build-framework' );

			$this->settings = array(
				'fields' => array(
					G5P()->widget()->setWidgetTitle(),
					array(
						'id'          => 'link',
						'title'       => esc_html__('Url redirect:', 'ruby-build-framework'),
						'type'        => 'text',
						'default'     => '',
					),
					array(
						'id'          => 'image',
						'title'       => esc_html__('Image:', 'ruby-build-framework'),
						'type'        => 'image',
						'sort'     => true,
					),
					array(
						'id'      => 'alt',
						'type'    => 'text',
						'default' => '',
						'title'   => esc_html__('Alt Of Image:', 'ruby-build-framework')
					),
				)
			);

			parent::__construct();
		}

		public function widget($args, $instance) {
			extract( $args, EXTR_SKIP );
			
			$title = G5P()->widget()->getValueParam($instance['title']);
			$alt = G5P()->widget()->getValueParam($instance['alt']);
			$link = G5P()->widget()->getValueParam($instance['link']);
			
			$title = apply_filters('widget_title', $title, $instance, $this->id_base);
			$image = apply_filters( 'widget_image', $instance['image'] );
			$image_url = $attachment_title = "";
			

			if( empty($image['id']) ){
				$image = '';
			}else{
				$image_url = $image['url'];
				$attachment_title = get_the_title($image['id']);
			}
			?>
			
			<?php echo wp_kses_post($args['before_widget']);
				if ($title) {
					echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
				}
			?>
			<?php if(!empty($image)):
				$alt_image = (!empty($alt)) ? $alt :$attachment_title;
			?>
				<?php if (!empty($link)):?>
				<a class="logo-content" href="<?php echo esc_url($link) ?>" title="<?php echo wp_kses_post($alt_image) ?>">
					<img alt="<?php echo wp_kses_post($alt_image) ?>" src="<?php echo esc_url($image_url);?>"/>
				</a>
				<?php else:?>
				<div class="logo-content">
					<img alt="<?php echo wp_kses_post($alt_image) ?>" src="<?php echo esc_url($image_url);?>"/>
				</div>
				<?php endif;?>
				
			<?php endif;
			echo wp_kses_post($args['after_widget']);
		}
	}
}