<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
if (!class_exists('G5P_Widget_Info_Box')) {
	class G5P_Widget_Info_Box extends  GSF_Widget
	{
		public function __construct() {
			$this->widget_cssclass    = 'widget-info_box';
			$this->widget_id          = 'gsf-info_box';
			$this->widget_name        = esc_html__( 'G5Plus: Info Box', 'ruby-build-framework' );

			$this->settings = array(
				'fields' => array(
					G5P()->widget()->setWidgetTitle(),
					array(
						'id'        => 'icon_size',
						'title'     => esc_html__('Icon Size: ', 'ruby-build-framework'),
						'type'      => 'select',
						'default'      => 'normal',
						'options' => array(
							'normal' => esc_html__('Normal', 'ruby-build-framework'),
							'small' => esc_html__('small', 'ruby-build-framework'),
							'mini' => esc_html__('mini', 'ruby-build-framework'),
						
						),
					),
					array(
						'id'        => 'icon_layout',
						'title'     => esc_html__('Icon Layout style: ', 'ruby-build-framework'),
						'type'      => 'select',
						'default'      => 'classic',
						'options' => array(
							'classic' => esc_html__('Classic', 'ruby-build-framework'),
							'background' => esc_html__('Background', 'ruby-build-framework'),
						
						),
					),
					array(
						'id'        => 'display_item',
						'title'     => esc_html__('Information item display: ', 'ruby-build-framework'),
						'type'      => 'select',
						'default'      => 'inline',
						'options' => array(
							'inline' => esc_html__('Display Inline', 'ruby-build-framework'),
							'block' => esc_html__('Display Block', 'ruby-build-framework'),
						
						),
					),
					array(
						'id'     => 'info-item',
						'title'  => esc_html__('Information Item', 'ruby-build-framework'),
						'type'   => 'panel',
						'sort'   => true,
						'fields' => array(
							array(
								'id'          => 'icon',
								'title'       => esc_html__('Set Icon:', 'ruby-build-framework'),
								'type'     => 'icon',
								'default'  => 'dashicons dashicons-share1',
							),
							array(
								'id'          => 'info_title',
								'title'       => esc_html__('Information Title', 'ruby-build-framework'),
								'type'        => 'text',
								'sort'     => true,
							),
							array(
								'id'          => 'info_subtitle',
								'title'       => esc_html__('Information Subtitle', 'ruby-build-framework'),
								'type'        => 'textarea',
								'sort'     => true,
							),
						)
					),
				)
			);
			parent::__construct();
		}

		public function widget($args, $instance) {
			extract( $args, EXTR_SKIP );
			
			//get title
			$title = G5P()->widget()->getValueParam($instance['title']);
			$title = apply_filters('widget_title', $title, $instance, $this->id_base);
			
			$icon_size = G5P()->widget()->getValueParam($instance['icon_size']);
			$icon_layout=G5P()->widget()->getValueParam($instance['icon_layout']);
			$item_display=G5P()->widget()->getValueParam($instance['display_item']);
			$icon_class = 'fs-12';
			if('normal' == $icon_size){
				$icon_class = 'fs-30';
			
			}elseif ('small' == $icon_size) {
				$icon_class = 'fs-23';
			}
			$wrapper_icon_shape=array(
				'info-shape',
				'accent-color',
				$icon_layout,
				$icon_class,
			);
			$wrapper_icon_class = implode(' ', array_filter($wrapper_icon_shape));
			
			$info_items = $instance['info-item'];
			
			?>
			<?php echo wp_kses_post($args['before_widget']);
				if ($title) {
					echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
				}
			?>
			
			<?php if(count($info_items)>0):?>
			<ul class="item-display-<?php echo esc_attr($item_display) ?>">
				<?php foreach ($info_items as $info_item){
					$icon = G5P()->widget()->getValueParam($info_item['icon']);
					if(!empty($icon)){
					$icon_html = '<i class="'.$icon.'"></i>';
					}
					$info_title = G5P()->widget()->getValueParam($info_item['info_title']);
					$info_subtitle = G5P()->widget()->getValueParam($info_item['info_subtitle']);
					?>
				<li>
					<?php if(!empty($icon)):?>
						<div class="<?php echo esc_attr($wrapper_icon_class)?>">
							<div class="icon"><?php echo wp_kses_post($icon_html) ?></div>
						</div>
					<?php endif;?>
					
					<?php if( !empty($info_title) || !empty($info_subtitle)):?>
						<div class="info-content">
							
							<?php if(!empty($info_title)):?>
								<h6 class="uppercase"> <?php echo esc_attr($info_title)?></h6>
							<?php endif; ?>
							
							<?php if(!empty($info_subtitle)):?>
								<p> <?php echo wp_kses_post($info_subtitle)?></p>
							<?php endif; ?>
						
						</div>
					<?php endif;?>
				</li>
					<?php }?>
			</ul>
			<?php endif;
			echo wp_kses_post($args['after_widget']);
		}
	}
}
