<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
if (!class_exists('G5P_Widget_Heading')) {
	class G5P_Widget_Heading extends  GSF_Widget
	{
		public function __construct() {
			$this->widget_cssclass    = 'widget-heading';
			$this->widget_id          = 'gsf-heading';
			$this->widget_name        = esc_html__( 'G5Plus: Heading', 'ruby-build-framework' );
			$this->settings = array(
				'fields' => array(
					array(
						'id'      => 'title',
						'type'    => 'text',
						'default' => '',
						'title'   => esc_html__('Text Title:', 'ruby-build-framework')
					),
					array(
						'id'      => 'subtitle',
						'type'    => 'text',
						'default' => 'What You Get From Us',
						'title'   => esc_html__('Text Subtitle:', 'ruby-build-framework')
					),
					array(
						'id' => 'subtitle_italic',
						'type' => 'switch',
						'title' => esc_html__('Subtitle Italic', 'ruby-build-framework'),
						'default' => ''
					),
					
					array(
						'id'        => 'title_style',
						'title'     => esc_html__('Title Style: ', 'ruby-build-framework'),
						'type'      => 'select',
						'default'      => 'subtitle-top',
						'options' => array(
							'subtitle-top' => esc_html__('Subtitle Top', 'ruby-build-framework'),
							'subtitle-bottom' => esc_html__('Subtitle Bottom', 'ruby-build-framework'),
						
						),
					),
					array(
						'id'        => 'heading_size',
						'title'     => esc_html__('Heading Size: ', 'ruby-build-framework'),
						'type'      => 'select',
						'default'      => 'normal',
						'options' => array(
							'normal' => esc_html__('Normal', 'ruby-build-framework'),
							'small' => esc_html__('small', 'ruby-build-framework'),
						
						),
					),
				)
			);
			parent::__construct();
		}

		public function widget($args, $instance) {
			extract( $args, EXTR_SKIP );
			
			//get title
			$title = G5P()->widget()->getValueParam($instance['title']);
			$subtitle = G5P()->widget()->getValueParam($instance['subtitle']);
			$title_style = G5P()->widget()->getValueParam($instance['title_style']);
			$heading_size = G5P()->widget()->getValueParam($instance['heading_size']);
			$subtitle_italic ='';
			$wrapper_classes = array(
				'widget-heading-wrap',
				'heading-'.$title_style,
				'heading-'.$heading_size,
			);
			if('on' == $instance['subtitle_italic']){
				$subtitle_italic = 'text-italic';
			}
			
			$wrapper_class = implode(' ', array_filter($wrapper_classes));
			?>

			<?php echo wp_kses_post($args['before_widget']);
			    if ( (!empty($title)) || (!empty($subtitle)) ) {
			    
					$before_subtitle = '<span class="heading-subtitle accent-color '.$subtitle_italic.'">';
					$after_subtitle = '</span>';
					$before_title='<h4 class="heading-title uppercase">';
					$after_title='</h4>';
					
					echo wp_kses_post('<div class="'.$wrapper_class.'">');
					if( empty($title) || empty($subtitle) ){
						if( empty($title) ){
							echo wp_kses_post($before_subtitle . $subtitle . $after_subtitle);
						}else{
							echo wp_kses_post($before_title . $title . $after_title);
						}
					
					}else{
						$title_content = $before_title . $title . $after_title;
						$subtitle_content = $before_subtitle . $subtitle . $after_subtitle;
						if( 'subtitle-top' == $title_style ){
							echo wp_kses_post($subtitle_content);
							echo wp_kses_post($title_content);
						}else{
							echo wp_kses_post($title_content);
							echo wp_kses_post($subtitle_content);
						}
					}
					
					echo wp_kses_post('</div>');
				}
			echo wp_kses_post($args['after_widget']);
		}
	}
}
