<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $css_animation
 * @var $animation_delay
 * @var $animation_duration
 * @var $values
 * Shortcode class
 * @var $this WPBakeryShortCode_G5Plus_Our_Team
 */

$el_class = $css_animation = $animation_delay = $animation_duration = $values = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);


$wrapper_classes = array(
	'gf-time-line claerfix',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class($css),
	$responsive
);


//animation
if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-timeline'), G5P()->helper()->getAssetUrl('shortcodes/timeline/assets/css/timeline.min.css'), array(), G5P()->pluginVer());
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$class_to_filter .= vc_shortcode_custom_css_class($atts['css'], ' ');
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
?>

<div class="<?php echo esc_attr($css_class) ?>">
	<?php $values = (array)vc_param_group_parse_atts($values);
	if (count($values) > 0):?>
		<ul class="time-line-items">
			<?php
			foreach ($values as $value):
				// get image src
				$title = isset($value['title']) ? $value['title'] : '';
				$description = isset($value['description']) ? $value['description'] : '';
				$time = isset($value['time']) ? $value['time'] : '';
				?>
				<li class="time-line-item clearfix">
					<div class="time-line-icon">
						<div class="icon">
							<i class="<?php echo esc_attr($value['icon_font']) ?>"></i>
						</div>
						<h4 class="time mg-bottom-0 fw-normal letter-spacing-03"><?php echo esc_html($time) ?></h4>
					</div>
					<div class="time-line-content">
						<div class="content-inner">
							<?php if (!empty($title)): ?>
								<h5 class="time-line-title mg-top-0 fw-normal">
									<?php echo esc_html($title) ?>
								</h5>
							<?php endif; ?>
							<?php if (!empty($description)): ?>
								<p>
									<?php echo esc_html($description) ?>
								</p>
							<?php endif; ?>
						</div>
					</div>
				</li>
			<?php endforeach; ?>
		</ul>
	<?php endif; ?>
</div>