<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 10/11/2016
 * Time: 10:25 AM
 */
$class_item_number = 'avatar-active-' . $item_active;
$values = (array)vc_param_group_parse_atts($values); ?>
	<div class="testimonials-avatar-wrap <?php echo esc_attr($class_item_number) ?>">
		<div class="owl-carousel manual testimonials-avatar-slider clearfix"
			 data-item-active="<?php echo esc_attr($item_active) ?>">
			<?php $item_index = 0; ?>
			<?php foreach ($values as $value):
				$title = isset($value['title']) ? $value['title'] : '';
				$name = isset($value['author_name']) ? $value['author_name'] : $title;
				$avatar = isset($value['image']) ? $value['image'] : '';
				if (!empty($avatar)) {
                    $image_src = '';
                    if (function_exists('g5plusRubyBuild')) {
                        $image_src =  g5plusRubyBuild()->image_resize()->resize(array(
                            'image_id' => $avatar,
                            'width' => 44,
                            'height' => 44
                        ));
                        if (sizeof($image_src) > 0 && !empty($image_src)) {
                            $image_src = $image_src['url'];
                        }
                    }
				} ?>
				<div class="tes-avatar-item" data-index="<?php echo esc_attr($item_index) ?>">
					<?php if (!empty($image_src)): ?>
						<img src="<?php echo esc_url($image_src); ?>" alt="<?php echo esc_attr($name); ?>">
					<?php endif; ?>
				</div>
				<?php $item_index++; ?>
			<?php endforeach; ?>
		</div>
	</div>
	
<div class="owl-carousel manual testimonials-quoter-slider clearfix">
    <?php $item_index_single = 0; ?>
    <?php foreach ($values as $value):
        $name = isset($value['author_name']) ? $value['author_name'] : '';
		$avatar = isset($value['image']) ? $value['image'] : '';
        $title = isset($value['title']) ? $value['title'] : '';
        $testimonials = isset($value['author_bio']) ? $value['author_bio'] : '';
        $job = isset($value['author_job']) ? $value['author_job'] : '';
        $url = isset($value['author_link']) ? $value['author_link'] : '';
		if (!empty($avatar)) {
            $image_src = '';
            if (function_exists('g5plusRubyBuild')) {
                $image_src =  g5plusRubyBuild()->image_resize()->resize(array(
                    'image_id' => $avatar,
                    'width' => 122,
                    'height' => 122
                ));
                if (sizeof($image_src) > 0 && !empty($image_src)) {
                    $image_src = $image_src['url'];
                }
            }
		}?>
        <div class="testimonial-item" data-index-single="<?php echo esc_attr($item_index_single) ?>">
			<div class="tes-avatar-item">
				<?php if (!empty($image_src)): ?>
					<img src="<?php echo esc_url($image_src); ?>" alt="<?php echo esc_attr($name); ?>">
				<?php endif; ?>
			</div>
			<div class="test-item-content-wrap">
				<div class="test-item-content">
					<?php if (!empty($title)): ?>
						<h4 class="title primary-font fs-20 fw-normal"><?php echo esc_attr($title) ?></h4>
					<?php endif; ?>
					<?php if (!empty($testimonials)): ?>
						<p><?php echo esc_html($testimonials); ?></p>
					<?php endif; ?>
				</div>
				<?php if (!empty($name) || !empty($job)): ?>
					<div class="test-item-info clearfix">
						<div class="test-item-info-text">
							<?php if (!empty($name)): ?>
								<h5 class="fs-18 fw-bold">
									<?php if (!empty($url)): ?>
									<a href="<?php echo esc_url($url) ?>">
										<?php endif;
										echo esc_attr($name);
										if (!empty($url)): ?>
									</a>
								<?php endif; ?>
								</h5>
							<?php endif; ?>
							<?php if (!empty($job)): ?>
								<span class="heading_font accent-color"><?php echo esc_html($job); ?></span>
							<?php endif; ?>
						</div>
					</div>
				<?php endif; ?>
			</div>
        </div>
        <?php $item_index_single++; ?>
    <?php endforeach; ?>
</div>
