<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $columns
 * @var $testimonials_layout
 * @var $el_class
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $css
 * @var $item_active
 * @var $values
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Testimonials
 */

$columns = $testimonials_layout= $el_class = $css_animation = $animation_duration = $animation_delay = $css = $item_active = $values = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);

$wrapper_classes = array(
	'g5plus-testimonials',
	'testimonials-' . $testimonials_layout,
	'clearfix',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class( $css ),
	$responsive
);
//animation

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-testimonials'), G5P()->helper()->getAssetUrl('shortcodes/testimonials/assets/css/testimonials.min.css'), array(), G5P()->pluginVer());
}


wp_enqueue_script(G5P()->assetsHandle('testimonials'), G5P()->helper()->getAssetUrl('shortcodes/testimonials/assets/js/testimonials.min.js'), array( 'jquery' ), G5P()->pluginVer(), true);

$class_to_filter = implode(' ', $wrapper_classes);
$class_to_filter .= vc_shortcode_custom_css_class($css, ' ');
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
?>

<div class="<?php echo esc_attr($css_class) ?>">
	<?php G5P()->helper()->getTemplate('shortcodes/testimonials/templates/testimonials-avatar-slider-horizontal', array('values' => $values, 'item_active' => $item_active)); ?>
</div>
