<?php
return array(
	'base' => 'gsf_testimonials',
	'name' => esc_html__( 'Testimonials', 'ruby-build-framework' ),
	'icon' => 'fa fa-quote-right',
	'category' => G5P()->shortcode()->get_category_name(),
	'params' => array(
		array(
			'type'        => 'dropdown',
			'heading'     => esc_html__('Testimonials Layout', 'ruby-build-framework'),
			'description' => esc_html__('Select our testimonial layout.', 'ruby-build-framework'),
			'param_name'  => 'testimonials_layout',
			'value'       => array(
				esc_html__('Slider Full','ruby-build-framework')     => 'slider-full',
				esc_html__('Avatar Slider Horizontal','ruby-build-framework') => 'avatar-slider-horizontal',
			),
			'admin_label' => true,
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__('Avatar Active', 'ruby-build-framework'),
			'param_name'       => 'item_active',
			'value'            => array('1' => 1, '2' => 2, '3' => 3, '4' => 4),
			'std'              => 3,
			'dependency'  => array(
				'element'            => 'testimonials_layout',
				'value' => array('avatar-slider-horizontal')
			),
		),
		
		array(
			'type'        => 'param_group',
			'heading'     => esc_html__('Values', 'ruby-build-framework'),
			'param_name'  => 'values',
			'description' => esc_html__('Enter values for author', 'ruby-build-framework'),
			'value'       => '',
			'params'      => array(
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__('Title', 'ruby-build-framework'),
					'param_name'  => 'title',
					'admin_label' => true,
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__('Author Testimonial Contents', 'ruby-build-framework'),
					'param_name' => 'author_bio'
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__('Author Name', 'ruby-build-framework'),
					'param_name'  => 'author_name',
					'admin_label' => true,
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__('Author Job', 'ruby-build-framework'),
					'param_name'  => 'author_job',
					'admin_label' => true,
				),
				array(
					'type'        => 'attach_image',
					'heading'     => esc_html__('Upload Avatar:', 'ruby-build-framework'),
					'param_name'  => 'image',
					'value'       => '',
					'description' => esc_html__('Upload avatar for author.', 'ruby-build-framework'),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__('Author Link', 'ruby-build-framework'),
					'param_name' => 'author_link'
				),
			)
		),
		/*array(
			'type'             => 'checkbox',
			'heading'          => esc_html__('Auto play', 'ruby-build-framework'),
			'param_name'       => 'auto_play',
			'std'              => 'true',
			'edit_field_class' => 'vc_col-sm-4 vc_column',
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__('Autoplay Timeout', 'ruby-build-framework'),
			'param_name'  => 'autoplaytimeout',
			'description' => esc_html__('Autoplay interval timeout.', 'ruby-build-framework'),
			'value'       => '',
			'std'         => 5000,
			'dependency'  => array('element' => 'auto_play', 'value' => 'true'),
		),*/
		
		G5P()->shortcode()->vc_map_add_css_animation(),
		G5P()->shortcode()->vc_map_add_animation_duration(),
		G5P()->shortcode()->vc_map_add_animation_delay(),
		G5P()->shortcode()->vc_map_add_extra_class(),
		G5P()->shortcode()->vc_map_add_css_editor(),
		G5P()->shortcode()->vc_map_add_responsive()
	),
);