/**
 * Created by Administrator on 10/3/2016.
 */

(function ($) {
	"use strict";
	var G5PlusTestimonials = {
		init: function () {
			if ($.isFunction($.fn.owlCarousel)) {
				G5PlusTestimonials.sync_slider();
			}
		},
		sync_slider: function () {
			$('.g5plus-testimonials.testimonials-avatar-slider-horizontal').each(function () {
				var $lazy_load = $(this).attr('data-lazy-load');
				if (typeof $lazy_load == 'undefined') {
					G5PlusTestimonials.init_slider_nav($(this));
				} else {
					$(this).on('lazy-load', function () {
						G5PlusTestimonials.init_slider_nav($(this));
					})
				}
				
			})
			$('.g5plus-testimonials.testimonials-slider-full').each(function () {
				var $lazy_load = $(this).attr('data-lazy-load');
				if (typeof $lazy_load == 'undefined') {
					G5PlusTestimonials.init_slider_nav($(this));
				} else {
					$(this).on('lazy-load', function () {
						G5PlusTestimonials.init_slider_nav($(this));
					})
				}
				
			})
		},
		init_slider_nav: function ($elm) {
			var isRTL = $('body').hasClass('rtl');
			var sync1 = $('.testimonials-quoter-slider', $elm);
			var sync2 = $('.testimonials-avatar-slider', $elm);
			var syncedSecondary = true;
			var $item_active = sync2.attr('data-item-active');
			var $total_item = $('.tes-avatar-item', sync2).length;
			var $item_reset = $item_active;
			var item_count = $total_item;
			if ($item_active < $total_item)
				$total_item = $item_active;
			var $start_position = Math.ceil($total_item / 2) - 1;
			var $item_responsive = 5;
			if ($item_active == 4) {
				$item_responsive = 4;
			}
			if ($item_active == 3) {
				$item_responsive = 3;
			}
			if ($item_active == 2) {
				$item_responsive = 2;
			}
			if ($item_active == 1) {
				$item_responsive = 1;
			}
			
			$(window).on('orientationchange', function () {
				vertical_slider();
			});
			vertical_slider();
			
			
			/*Initialized Sync Slider*/
			sync1.owlCarousel({
				items: 1,
				slideSpeed: 2000,
				nav: false,
				center: true,
				dots: false,
				loop: true,
				autoPlay: true,
				responsiveRefreshRate: 200,
				onDragged: dragSingle,
				onChange: vertical_slider,
				onResize: vertical_slider,
				autoHeight: true,
				rtl: isRTL
			}).on('changed.owl.carousel', syncPosition);
			sync2.on('initialized.owl.carousel', function () {
				sync2.find(".owl-item").eq(0).addClass("current");
			}).owlCarousel({
				items: $item_active,
				dots: true,
				nav: true,
				autoPlay: true,
				smartSpeed: 200,
				slideSpeed: 500,
				center: true,
				slideBy: 1,
				responsiveRefreshRate: 100,
				navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
				startPosition: $start_position,
				onChange: vertical_slider,
				mouseDrag: false,
				rtl: isRTL,
				responsive: {
					0: {
						items: 1
					},
					480: {
						items: $item_responsive
					},
					800: {
						items: $item_active
					}
				}
			}).on('changed.owl.carousel', syncPosition2);
			function syncPosition(el) {
				var count = el.item.count - 1;
				var current = Math.round(el.item.index - (el.item.count / 2) - 0.5);
				if (current < 0) {
					current = count;
				}
				if (current > count) {
					current = 0;
				}
				
				//end block
				sync2
					.find(".owl-item")
					.removeClass("current")
					.eq(current)
					.addClass("current");
				var onscreen = sync2.find('.owl-item.active').length - 1;
				var start = sync2.find('.owl-item.active').first().index();
				var end = sync2.find('.owl-item.active').last().index();
				if (sync2.data('owl.carousel') != undefined) {
					if (current > end) {
						sync2.data('owl.carousel').to(current, 100, true);
					}
					if (current < start) {
						sync2.data('owl.carousel').to(current - onscreen, 100, true);
					}
				}
			}
			
			function syncPosition2(el) {
				if (syncedSecondary) {
					var number = el.item.index;
					sync1.data('owl.carousel').to(number, 500, true);
				}
			}
			
			sync2.on("click", ".owl-item", function (e) {
				e.preventDefault();
				var number = $(this).index();
				sync1.data('owl.carousel').to(number, 500, true);
				if (typeof $(this).children() != 'undefined') {
					var $index = $(this).children().attr('data-index');
					sync1.trigger('to.owl.carousel', [$index, 500]);
					sync2.trigger('to.owl.carousel', [$index, 300]);
				}
			});
			/*Function Calculator*/
			function vertical_slider() {
				var height_sync2 = 0;
				var height_sync1 = $('.owl-stage-outer', sync1).height();
				for (var i = 1; i <= 5; i++) {
					if ($item_reset == i) {
						sync2.parent().css('width', i * 52);
						height_sync2 = i * 52;
						var half_height_sync2 = height_sync2 / 2;
						sync2.parent().css('top', 155);
						var window_width = window.innerWidth,
							location = isRTL ? 'right' : 'left';
						if (window_width < 1500) {
							//17 = scroll
							sync2.parent().css(location, (262 - (i * 52)) / 2);
						}
						else {
							sync2.parent().css(location, (262 - (i * 52)) / 2);
						}
					}
				}
			}
			
			function dragSingle() {
				var single_index = sync1.find('.owl-item.active .testimonial-item').attr('data-index-single');
				$('.tes-avatar-item[data-index="' + single_index + '"]', sync2).parent().click();
			}
		},
		
	};
	$(document).ready(G5PlusTestimonials.init);
	$(window).resize(G5PlusTestimonials.init);
	$(window).load(G5PlusTestimonials.sync_slider);
})(jQuery);