<?php
return array(
	'base' => 'gsf_social_networks',
	'name' => esc_html__( 'Social Networks', 'ruby-build-framework' ),
	'icon' => 'fa fa-share-alt',
	'category' => G5P()->shortcode()->get_category_name(),
	'params' => array(
		array(
			'param_name' => 'social_networks',
			'heading' => esc_html__('Social Networks', 'ruby-build-framework'),
			'type' => 'gsf_selectize',
			'multiple' => true,
			'drag' => true,
			'description' => esc_html__('Select Social Networks', 'ruby-build-framework'),
			'value' => G5P()->shortcode()->switch_array_key_value(G5P()->settings()->get_social_networks())
		),
		array(
			'param_name' => 'social_shape',
			'heading' => esc_html__('Social Shape', 'ruby-build-framework'),
			'type' => 'dropdown',
			'value' => array(
				esc_html__( 'Classic', 'ruby-build-framework' ) => 'classic',
				esc_html__( 'Circle', 'ruby-build-framework' ) => 'circle'
			),
			'std' => 'classic'
		),
		G5P()->shortcode()->vc_map_add_css_animation(),
		G5P()->shortcode()->vc_map_add_animation_duration(),
		G5P()->shortcode()->vc_map_add_animation_delay(),
		G5P()->shortcode()->vc_map_add_extra_class(),
		G5P()->shortcode()->vc_map_add_css_editor(),
		G5P()->shortcode()->vc_map_add_responsive()
	),
);