<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $show_category_filter
 * @var $show
 * @var $portfolio_layout
 * @var $category
 * @var $project_ids
 * @var $portfolio_columns_gutter
 * @var $portfolio_columns
 * @var $portfolio_columns_md
 * @var $portfolio_columns_sm
 * @var $portfolio_columns_xs
 * @var $portfolio_image_size
 * @var $portfolio_image_ratio
 * @var $portfolio_image_ratio_custom_width
 * @var $portfolio_image_ratio_custom_height
 * @var $portfolio_image_ratio_custom
 * @var $portfolio_per_page
 * @var $portfolio_paging
 * @var $portfolio_animation
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $el_class
 * @var $css
 * @var $responsive
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Projects
 */
$show = $portfolio_layout = $show_category_filter = $category = $project_ids = $portfolio_columns_gutter = $portfolio_columns =
$portfolio_columns_md = $portfolio_columns_sm = $portfolio_columns_xs = $portfolio_columns_mb
	= $portfolio_image_size = $portfolio_image_ratio = $portfolio_image_ratio_custom_width = $portfolio_image_ratio_custom_height =
$portfolio_image_width = $portfolio_per_page = $portfolio_paging =
$portfolio_animation = $css_animation = $animation_duration = $animation_delay = $el_class = $css = $responsive = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);
$portfolio_image_ratio_custom = array(
	'width'  => $portfolio_image_ratio_custom_width,
	'height' => $portfolio_image_ratio_custom_height,

);
$portfolio_image_width = array(
	'width' => $portfolio_image_width
);
$wrapper_classes = array(
	'gf-portfolio',
	'clearfix',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class($css),
	$responsive
);

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

$query_args = array(
	'post_type'      => 'portfolio',
	'taxonomy'       => 'portfolio_cat',
	'itemSelector'   => 'article',
	'posts_per_page' => (is_numeric($portfolio_per_page) && $portfolio_per_page > 0) ? $portfolio_per_page : '-1',
);

if ($show != 'projects') {
	if (!empty($category)) {
		$query_args['tax_query'][] = array(
			'taxonomy' => 'portfolio_cat',
			'terms'    => explode(',', $category),
			'field'    => 'slug',
			'operator' => 'IN'
		);
		$category = G5P()->helper()->get_term_ids_from_slugs(explode(',', $category), 'portfolio_cat');
	}
} else {
	$category = array();
	$show_category_filter = '';
}
switch ($show) {
	case 'new-in':
		$query_args['orderby'] = 'date';
		$query_args['order'] = 'DESC';
		break;
	case 'old-in':
		$query_args['orderby'] = 'date';
		$query_args['order'] = 'ASC';
		break;
	case 'projects':
		if (!empty($project_ids)) {
			$project_ids = explode(',', $project_ids);
			$query_args['post__in'] = $project_ids;
			$query_args['posts_per_page'] = -1;
			$query_args['orderby'] = 'post__in';
		}
		break;
}

if ('all' == $show) {
	$query_args['order'] = $order;
	$query_args['orderby'] = 'date';
}


$settings = array(
	'post_columns_gutter'    => $portfolio_columns_gutter,
	'post_layout'            => $portfolio_layout,
	'post_paging'            => $portfolio_paging,
	'category_filter_enable' => false,
	'cat'                    => $category
);
if ('on' === $show_category_filter) {
	$settings['category_filter_enable'] = true;
	$settings['current_cat'] = -1;
}

if ($portfolio_animation !== '') {
	$settings['post_animation'] = $portfolio_animation;
}
$portfolio_columns = intval($portfolio_columns);
$portfolio_columns_gutter = intval($portfolio_columns_gutter);
$portfolio_columns_md = intval($portfolio_columns_md);
$portfolio_columns_sm = intval($portfolio_columns_sm);
$portfolio_columns_xs = intval($portfolio_columns_xs);
$portfolio_columns_mb = intval($portfolio_columns_mb);

if (in_array($portfolio_layout, array('grid', 'masonry'))) {
	$settings['post_columns'] = array(
		'lg' => $portfolio_columns,
		'md' => $portfolio_columns_md,
		'sm' => $portfolio_columns_sm,
		'xs' => $portfolio_columns_xs,
		'mb' => $portfolio_columns_mb,
	);
}

$settings['image_size'] = $portfolio_image_size;
$settings['image_ratio'] = $portfolio_image_ratio;
$settings['image_ratio_custom'] = $portfolio_image_ratio_custom;
$settings['image_width'] = $portfolio_image_width;

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$class_to_filter .= vc_shortcode_custom_css_class($css, ' ');
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
?>
<div class="<?php echo esc_attr($css_class) ?>">
	<?php if (function_exists('g5plusRubyBuild')) {
		g5plusRubyBuild()->portfolio()->archive_markup($query_args, $settings);
	} ?>
</div>