<?php
/**
 * The template for displaying config.php
 *
 * @package WordPress
 * @subpackage ruby build
 * @since ruby build 1.0
 */
return array(
	'base'     => 'gsf_projects',
	'name'     => esc_html__('Projects', 'ruby-build-framework'),
	'category' => G5P()->shortcode()->get_category_name(),
	'icon'     => 'fa fa-cubes',
	'params'   => array_merge(
		array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Show', 'ruby-build-framework'),
				'param_name' => 'show',
				'value'      => array(
					esc_html__('All', 'ruby-build-framework')             => 'all',
					esc_html__('New In', 'ruby-build-framework')          => 'new-in',
					esc_html__('Old In', 'ruby-build-framework')          => 'old-in',
					esc_html__('Narrow Projects', 'ruby-build-framework') => 'projects'
				)
			),
			array(
				'type'        => 'autocomplete',
				'heading'     => esc_html__('Narrow Projects', 'ruby-build-framework'),
				'param_name'  => 'project_ids',
				'settings'    => array(
					'multiple'      => true,
					'sortable'      => true,
					'unique_values' => true,
				),
				'save_always' => true,
				'description' => esc_html__('Enter List of Projects', 'ruby-build-framework'),
				'dependency'  => array('element' => 'show', 'value' => 'projects'),
			),
			G5P()->shortCode()->vc_map_add_pojects_narrow_categories(array(
				'dependency' => array('element' => 'show', 'value_not_equal_to' => array('projects'))
			)),
			array(
				'type'             => 'dropdown',
				'heading'          => esc_html__('Sort order', 'ruby-build-framework'),
				'param_name'       => 'order',
				'value'            => array(
					esc_html__('Descending', 'ruby-build-framework') => 'DESC',
					esc_html__('Ascending', 'ruby-build-framework')  => 'ASC'
				),
				'description'      => esc_html__('Designates the ascending or descending order.', 'ruby-build-framework'),
				'dependency'       => array('element' => 'show', 'value' => 'all'),
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			),
			array(
				'type'             => 'gsf_switch',
				'heading'          => esc_html__('Category Filter', 'ruby-build-framework'),
				'param_name'       => 'show_category_filter',
				'std'              => '',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'dependency'       => array('element' => 'show', 'value_not_equal_to' => 'projects'),
			),
			array(
				'param_name'  => 'portfolio_layout',
				'heading'     => esc_html__('Post Layout', 'ruby-build-framework'),
				'description' => esc_html__('Specify your project layout', 'ruby-build-framework'),
				'type'        => 'gsf_image_set',
				'value'       => G5P()->settings()->get_portfolio_layout(),
				'std'         => 'grid',
				'admin_label' => true
			),
			array(
				'type'        => 'textfield',
				'param_name'  => 'portfolio_image_size',
				'heading'     => esc_html__('Image size', 'ruby-build-framework'),
				'description' => esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).', 'ruby-build-framework'),
				'value'       => '400x328',
				'dependency'  => array('element' => 'portfolio_layout', 'value_not_equal_to' => 'masonry'),
				'group'       => esc_html__('Image Size Options', 'ruby-build-framework'),
			),
			array(
				'param_name' => 'portfolio_image_ratio',
				'heading'    => esc_html__('Image ratio', 'ruby-build-framework'),
				'type'       => 'dropdown',
				'value'      => G5P()->shortcode()->switch_array_key_value(G5P()->settings()->get_image_ratio()),
				'default'    => '1x1',
				'group'      => esc_html__('Image Size Options', 'ruby-build-framework'),
				'dependency'  => array('element' => 'portfolio_image_size', 'value' => 'full'),
			),
			array(
				'type'             => 'gsf_number',
				'param_name'       => 'portfolio_image_ratio_custom_width',
				'heading'          => esc_html__('Image ratio custom width', 'ruby-build-framework'),
				'args'             => array(
					'min'  => 1,
					'max'  => 500,
					'step' => 1
				),
				'group'            => esc_html__('Image Size Options', 'ruby-build-framework'),
				'dependency'  => array('element' => 'portfolio_image_ratio', 'value' => 'custom'),
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			),
			array(
				'type'             => 'gsf_number',
				'param_name'       => 'portfolio_image_ratio_custom_height',
				'heading'          => esc_html__('Image ratio custom height', 'ruby-build-framework'),
				'args'             => array(
					'min'  => 1,
					'max'  => 500,
					'step' => 1
				),
				'group'            => esc_html__('Image Size Options', 'ruby-build-framework'),
				'dependency'  => array('element' => 'portfolio_image_ratio', 'value' => 'custom'),
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			),
			array(
				'param_name'  => 'portfolio_image_width',
				'heading'     => esc_html__('Image Width', 'ruby-build-framework'),
				'description' => esc_html__('Enter image width', 'ruby-build-framework'),
				'type'        => 'gsf_number',
				'args'        => array(
					'min'  => 1,
					'max'  => 500,
					'step' => 1
				),
				'std'         => 400,
				'dependency'  => array('element' => 'portfolio_layout', 'value' => 'masonry'),
				'group'       => esc_html__('Image Size Options', 'ruby-build-framework'),
			),
			array(
				'param_name'       => 'portfolio_per_page',
				'heading'          => esc_html__('Posts Per Page', 'ruby-build-framework'),
				'description'      => esc_html__('Enter number of project per page you want to display. Default 3', 'ruby-build-framework'),
				'type'             => 'textfield',
				'std'              => 6,
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			),
			array(
				'param_name'       => 'portfolio_columns_gutter',
				'heading'          => esc_html__('Post Columns Gutter', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your horizontal space between project.', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => G5P()->shortcode()->switch_array_key_value(G5P()->settings()->get_post_columns_gutter()),
				'std'              => '30',
				'dependency'       => array('element' => 'portfolio_layout', 'value_not_equal_to' => 'carousel-3d'),
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			),
			array(
				'param_name'       => 'portfolio_columns',
				'heading'          => esc_html__('Large Devices', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your team columns on large devices (>= 1200px)', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => G5P()->settings()->get_post_columns(),
				'std'              => '3',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'dependency'       => array('element' => 'portfolio_layout', 'value' => array('grid', 'masonry')),
			),
			array(
				'param_name'       => 'portfolio_columns_md',
				'heading'          => esc_html__('Medium Devices', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your team columns on medium devices (>= 992px)', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => G5P()->settings()->get_post_columns(),
				'std'              => '2',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'dependency'       => array('element' => 'portfolio_layout', 'value' => array('grid', 'masonry')),
			),
			array(
				'param_name'       => 'portfolio_columns_sm',
				'heading'          => esc_html__('Small Devices', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your team columns on small devices (>= 768px)', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => G5P()->settings()->get_post_columns(),
				'std'              => '1',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'dependency'       => array('element' => 'portfolio_layout', 'value' => array('grid', 'masonry')),
			),
			array(
				'param_name'       => 'portfolio_columns_xs',
				'heading'          => esc_html__('Extra Small Devices ', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your team columns on extra small devices (< 768px)', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => G5P()->settings()->get_post_columns(),
				'std'              => '1',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'dependency'       => array('element' => 'portfolio_layout', 'value' => array('grid', 'masonry')),
			),
			array(
				'param_name'       => 'portfolio_columns_mb',
				'heading'          => esc_html__('Extra Extra Small Devices ', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your team columns on extra extra small devices (< 468px)', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => G5P()->settings()->get_post_columns(),
				'std'              => '1',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'dependency'       => array('element' => 'portfolio_layout', 'value' => array('grid', 'masonry')),
			),
			array(
				'param_name'       => 'portfolio_paging',
				'heading'          => esc_html__('Our team Paging', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your team paging mode', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => array(
					esc_html__('No Pagination', 'ruby-build-framework')          => 'none',
					esc_html__('Pagination', 'ruby-build-framework')             => 'pagination',
					esc_html__('Ajax - Pagination', 'ruby-build-framework')      => 'pagination-ajax',
					esc_html__('Ajax - Next Prev', 'ruby-build-framework')       => 'next-prev',
					esc_html__('Ajax - Load More', 'ruby-build-framework')       => 'load-more',
					esc_html__('Ajax - Infinite Scroll', 'ruby-build-framework') => 'infinite-scroll'
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'std'              => 'none'
			),
			array(
				'param_name'       => 'portfolio_animation',
				'heading'          => esc_html__('Animation', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your team animation', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => G5P()->shortcode()->switch_array_key_value(G5P()->settings()->get_animation(true)),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'std'              => '-1'
			),
		),
		array(
			
			G5P()->shortcode()->vc_map_add_css_animation(),
			G5P()->shortcode()->vc_map_add_animation_duration(),
			G5P()->shortcode()->vc_map_add_animation_delay(),
			G5P()->shortcode()->vc_map_add_extra_class(),
			G5P()->shortcode()->vc_map_add_css_editor(),
			G5P()->shortcode()->vc_map_add_responsive()
		)
	)
);