<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $link
 * @var $el_class
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $css
 * @var $this WPBakeryShortCode_GSF_Project_meta
 */
$link = $title = $el_class = $css_animation = $animation_duration = $animation_delay = $css = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);
// link
$a_href = $a_title = $a_target = $a_rel = '';
//parse link
$link = ('||' === $link) ? '' : $link;
$link = vc_build_link($link);
$use_link = false;
if (strlen($link['url']) > 0) {
	$use_link = true;
	$a_href = $link['url'];
	$a_title = $link['title'];
	$a_target = $link['target'];
	$a_rel = $link['rel'];
}
if ($use_link) {
	$button_attributes[] = 'href="' . esc_url(trim($a_href)) . '"';
	if (empty($a_title)) {
		$a_title = $title;
	}
	$button_attributes[] = 'title="' . esc_attr(trim($a_title)) . '"';
	if (!empty($a_target)) {
		$button_attributes[] = 'target="' . esc_attr(trim($a_target)) . '"';
	}
	
	if (!empty($a_rel)) {
		$button_attributes[] = 'rel="' . esc_attr(trim($a_rel)) . '"';
	}
	$button_attributes = implode(' ', $button_attributes);
}
$wrapper_classes = array(
	'gf-portfolio-meta-wrap',
	'clearfix',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class($css),
	$responsive
);

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
?>
<div class="<?php echo esc_attr($css_class) ?>">
	<?php if (function_exists('g5plusRubyBuild')) {g5plusRubyBuild()->helper()->getTemplate('portfolio/single/portfolio-meta');}  ?>
	<?php if (!empty($title)): ?>
		<?php if ($use_link) : ?>
			<a class="btn btn-black btn-rounded btn-block" <?php echo($button_attributes); ?>><?php echo esc_attr($title)?></a>
		<?php else: ?>
			<button class="btn btn-black btn-rounded btn-block"><?php echo esc_attr($title)?></button>
		<?php endif; ?>
	<?php endif; ?>
</div>
