<?php
return array(
	'base' => 'gsf_products',
	'name' => esc_html__('Products','ruby-build-framework'),
	'icon' => 'fa fa-product-hunt',
    'category' => G5P()->shortcode()->get_category_name(),
	'params' =>  array_merge(
	    array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Show', 'ruby-build-framework'),
                'param_name' => 'show',
                'value' => array(
                    esc_html__('All', 'ruby-build-framework') => 'all',
                    esc_html__('Sale Off', 'ruby-build-framework') => 'sale',
                    esc_html__('New In', 'ruby-build-framework') => 'new-in',
                    esc_html__('Featured', 'ruby-build-framework') => 'featured',
                    esc_html__('Top rated', 'ruby-build-framework') => 'top-rated',
					esc_html__('Recent review', 'ruby-build-framework') => 'recent-review',
                    esc_html__('Best Selling', 'ruby-build-framework') => 'best-selling',
                    esc_html__('Narrow Products', 'ruby-build-framework') => 'products'
                )
            ),
            array(
                'type' => 'autocomplete',
                'heading' => esc_html__( 'Narrow Products', 'ruby-build-framework' ),
                'param_name' => 'product_ids',
                'settings' => array(
                    'multiple' => true,
                    'sortable' => true,
                    'unique_values' => true,
                ),
                'save_always' => true,
                'description' => esc_html__( 'Enter List of Products', 'ruby-build-framework' ),
                'dependency' => array('element' => 'show','value' => 'products'),
            ),
            G5P()->shortCode()->vc_map_add_product_narrow_categories(array(
                'dependency' => array('element' => 'show','value_not_equal_to' => array('products'))
            )),
            array(
                'type' => 'gsf_switch',
                'heading' => esc_html__('Category Filter', 'ruby-build-framework' ),
                'param_name' => 'show_category_filter',
                'std' => '',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
				'dependency' => array('element' => 'show','value_not_equal_to' => 'products'),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Category Filter Alignment', 'ruby-build-framework'),
                'param_name' => 'cate_filter_align',
                'value' => array(
                    esc_html__('Left', 'ruby-build-framework') => 'cate-filter-left',
                    esc_html__('Center', 'ruby-build-framework') => 'cate-filter-center',
                    esc_html__('Right', 'ruby-build-framework') => 'cate-filter-right'
                ),
                'std' => 'cate-filter-left',
                'dependency' => array('element'=>'show_category_filter', 'value'=> 'on'),
                'edit_field_class' => 'vc_col-sm-6 vc_column'
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Products Per Page', 'ruby-build-framework' ),
                'param_name' => 'products_per_page',
                'value' => 6,
                'admin_label' => true,
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'dependency' => array('element' => 'show','value_not_equal_to' => array('products'))
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Columns Gutter', 'ruby-build-framework'),
                'param_name' => 'columns_gutter',
                'value' => G5P()->shortcode()->switch_array_key_value( G5P()->settings()->get_post_columns_gutter() ),
                'std' => '30',
                'edit_field_class' => 'vc_col-sm-6 vc_column'
            ),

            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Order by', 'ruby-build-framework'),
                'param_name' => 'orderby',
                'value' => array(
                    esc_html__('Date', 'ruby-build-framework') => 'date',
                    esc_html__('Price', 'ruby-build-framework') => 'price',
                    esc_html__('Random', 'ruby-build-framework') => 'rand',
                    esc_html__('Sales', 'ruby-build-framework') => 'sales'
                ),
                'description' => esc_html__('Select how to sort retrieved products.', 'ruby-build-framework'),
                'dependency' => array('element' => 'show','value' => array('all', 'sale', 'featured')),
                'edit_field_class' => 'vc_col-sm-6 vc_column'
            ),

            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Sort order', 'ruby-build-framework'),
                'param_name' => 'order',
                'value' => array(
                    esc_html__('Descending', 'ruby-build-framework') => 'DESC',
                    esc_html__('Ascending', 'ruby-build-framework') => 'ASC'
                ),
                'description' => esc_html__('Designates the ascending or descending order.', 'ruby-build-framework'),
                'dependency' => array('element' => 'show','value' => array('all', 'sale', 'featured')),
                'edit_field_class' => 'vc_col-sm-6 vc_column'
            ),
            array(
                'type' => 'gsf_switch',
                'heading' => esc_html__('Is Slider?', 'ruby-build-framework' ),
                'param_name' => 'is_slider',
                'std' => '',
                'admin_label' => true,
                'edit_field_class' => 'vc_col-sm-6 vc_column'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Carousel Rows', 'ruby-build-framework'),
                'param_name' => 'rows',
                'value' => array(
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4'
                ),
                'dependency' => array('element' => 'is_slider','value' => 'on'),
                'group' => esc_html__('Slider Options','ruby-build-framework'),
                'edit_field_class' => 'vc_col-sm-6 vc_column'
            ),
            G5P()->shortcode()->vc_map_add_pagination(array(
                'dependency' => array('element' => 'is_slider', 'value' => 'on'),
                'group' => esc_html__('Slider Options', 'ruby-build-framework'),
                'edit_field_class' => 'vc_col-sm-6 vc_column'
            )),
            G5P()->shortcode()->vc_map_add_navigation(array(
                'dependency' => array('element' => 'is_slider', 'value' => 'on'),
                'group' => esc_html__('Slider Options', 'ruby-build-framework'),
            )),
            G5P()->shortcode()->vc_map_add_navigation_position(array(
                'group' => esc_html__('Slider Options', 'ruby-build-framework')
            )),
            G5P()->shortcode()->vc_map_add_navigation_style(array(
                'group' => esc_html__('Slider Options', 'ruby-build-framework')
            )),
			G5P()->shortCode()->vc_map_add_autoplay_enable(array(
				'dependency' => array('element' => 'is_slider', 'value' => 'on'),
				'group' => esc_html__('Slider Options', 'ruby-build-framework'),
			)),
			G5P()->shortCode()->vc_map_add_autoplay_timeout(array(
				'group' => esc_html__('Slider Options', 'ruby-build-framework'),
			)),
            array(
                'param_name' => 'product_paging',
                'heading' => esc_html__( 'Product Paging', 'ruby-build-framework' ),
                'description' => esc_html__( 'Specify your post paging mode', 'ruby-build-framework' ),
                'type' => 'dropdown',
                'value' => array(
                    esc_html__('No Pagination', 'ruby-build-framework')=> 'none',
                    esc_html__('Pagination', 'ruby-build-framework') => 'pagination',
                    esc_html__('Ajax - Pagination', 'ruby-build-framework') => 'pagination-ajax',
                    esc_html__('Ajax - Next Prev', 'ruby-build-framework') => 'next-prev',
                    esc_html__('Ajax - Load More', 'ruby-build-framework') => 'load-more',
                    esc_html__('Ajax - Infinite Scroll', 'ruby-build-framework') => 'infinite-scroll'
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'dependency' => array('element' => 'is_slider', 'value_not_equal_to' => array('on')),
                'std' => 'none'
            ),
            array(
                'param_name' => 'product_animation',
                'heading' => esc_html__( 'Product Animation', 'ruby-build-framework' ),
                'description' => esc_html__( 'Specify your product animation', 'ruby-build-framework' ),
                'type' => 'dropdown',
                'value' => G5P()->shortcode()->switch_array_key_value( G5P()->settings()->get_animation(true) ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'std' => ''
            ),
        ),
        G5P()->shortCode()->get_column_responsive(),
        array(
            G5P()->shortcode()->vc_map_add_css_animation(),
            G5P()->shortcode()->vc_map_add_animation_duration(),
            G5P()->shortcode()->vc_map_add_animation_delay(),
            G5P()->shortcode()->vc_map_add_extra_class(),
            G5P()->shortcode()->vc_map_add_css_editor(),
            G5P()->shortcode()->vc_map_add_responsive()
        )
	)
);