<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $name
 * @var $price
 * @var $text_time
 * @var $description
 * @var $values
 * @var $button_text
 * @var $link
 * @var $is_featured
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $el_class
 * @var $css
 * @var $responsive
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Pricing_tables
 */

$is_featured = $name = $price = $text_time = $description = $icon_font = $values = $button_text = $link = $css_animation = $animation_duration = $animation_delay = $el_class = $css = $responsive = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);
$is_featured_class = '';
$skin_class = 'skin-light';
if ('true' == $is_featured) {
	$is_featured_class = 'is-featured';
	$skin_class = 'skin-dark';
	
}
$wrapper_classes = array(
	'gf-pricing-tables',
	'gf-skin',
	$skin_class,
	$is_featured_class,
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class($css),
	$responsive
);
$price = !empty($price) ? $price : '';
$text_time = !empty($text_time) ? $text_time : '';
$values = (array)vc_param_group_parse_atts($values);

//parse link
$a_href = '';
$link = ('||' === $link) ? '' : $link;
$link = vc_build_link($link);
$use_link = false;
if (strlen($link['url']) > 0) {
	$use_link = true;
	$a_href = $link['url'];
	$a_title = $link['title'];
	$a_target = $link['target'];
}

$button_class = 'btn btn-primary btn-rounded btn-normal';

$icon_html = '';
if ('' != $icon_font) {
	$icon_html = '<i class="heading-color ' . esc_attr($icon_font) . '"></i>';
} else {
	$icon_html = '';
}
if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

if (!(defined('CSS_DEBUG') && CSS_DEBUG)) {
	wp_enqueue_style(G5P()->assetsHandle('g5-banner'), G5P()->helper()->getAssetUrl('shortcodes/pricing-tables/assets/css/pricing-tables.min.css'), array(), G5P()->pluginVer());
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
?>
<div class="<?php echo esc_attr($css_class) ?>">
	<div class="gs-pt-prices">
		<h4 class="fs-38 uppercase">
			<?php echo esc_attr($price) ?>
			<sub class="fs-12 fw-normal"><span class="fs-20 fw-bold">$</span><?php echo '/' . esc_attr($text_time) ?>
			</sub>
		</h4>
		<span class="fs-12"><?php echo esc_attr($description) ?></span>
	</div>
	<div class="gs-pt-name">
		<h4 class="gsf-white-text fs-16"><?php echo esc_attr($name) ?></h4>
	</div>
	<div class="gs-pt-content">
		<div class="gs-pt-icon"><?php echo wp_kses_post($icon_html); ?></div>
		<?php if (count($values) > 0): ?>
			<ul class="gsf-list-check gs-pt-features">
				<?php foreach ($values as $value):
					$feature = isset($value['features']) ? $value['features'] : '';
					?>
					<li class="gs-pt-feature"><span><?php echo esc_attr($feature) ?></span></li>
				<?php endforeach; ?>
			</ul>
		<?php endif; ?>
		<?php if (!empty($button_text)): ?>
			<a class="pricing-button <?php echo esc_attr($button_class) ?>"
			   href="<?php echo esc_url(trim($a_href)) ?>"><?php echo esc_html($button_text) ?></a>
		<?php endif; ?>
	</div>
</div>