<?php
return array(
	'base' => 'gsf_pricing_tables',
	'name' => esc_html__( 'Pricing Tables', 'ruby-build-framework' ),
	'icon' => 'fa fa-money',
	'category' => G5P()->shortcode()->get_category_name(),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Name', 'ruby-build-framework'),
			'param_name' => 'name',
			'admin_label' => true,
		),
		G5P()->shortcode()->vc_map_add_icon_font(),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Price', 'ruby-build-framework'),
			'param_name' => 'price',
			'admin_label' => true,
			'description' => esc_html__('EX: $100 or 100$', 'ruby-build-framework' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Text time', 'ruby-build-framework'),
			'description' => esc_html__('Enter text for time. Ex: day, mo or year', 'ruby-build-framework' ),
			'param_name' => 'text_time',
		),
		array(
			'type' => 'textarea',
			'heading' => esc_html__('Description', 'ruby-build-framework'),
			'description' => esc_html__('Enter description for package', 'ruby-build-framework' ),
			'param_name' => 'description',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__('Is Featured?', 'ruby-build-framework' ),
			'param_name' => 'is_featured',
			'admin_label' => true,
		),
		array(
			'type' => 'param_group',
			'heading' => esc_html__( 'Features', 'ruby-build-framework' ),
			'param_name' => 'values',
			'value' => urlencode( json_encode( array(
				array(
					'label' => esc_html__( 'Features', 'ruby-build-framework' ),
					'value' => '',
				),
			) ) ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Feature', 'ruby-build-framework'),
					'param_name' => 'features',
					'value' =>'',
				),
			),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Button Text', 'ruby-build-framework' ),
			'param_name' => 'button_text',
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		array(
			'type' => 'vc_link',
			'heading' => esc_html__('URL (Link)', 'ruby-build-framework' ),
			'param_name' => 'link',
			'description' => esc_html__('Add link to button.', 'ruby-build-framework' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group' => esc_html__('Button Options', 'ruby-build-framework')
		),
		
		/*
		array(
			'type' => 'checkbox',
			'heading' => esc_html__('Is Featured?', 'ruby-build-framework' ),
			'param_name' => 'is_featured_1',
			'admin_label' => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'dependency' => array('element' => 'pricing_style','value' => 'layout_text' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__('Is Featured?', 'ruby-build-framework' ),
			'param_name' => 'is_featured_2',
			'admin_label' => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'dependency' => array('element' => 'pricing_style','value' => 'full_package' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__('Featured Text', 'ruby-build-framework'),
			'param_name' => 'featured_text',
			'value' =>'',
			'dependency' => array('element' => 'is_featured_1','value' => 'true' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__('Upload Featured Image:', 'ruby-build-framework'),
			'param_name' => 'featured_image',
			'value' => '',
			'description' => esc_html__('Upload the custom image.', 'ruby-build-framework'),
			'dependency' => array('element' => 'is_featured','value' => 'true' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),*/
		G5P()->shortcode()->vc_map_add_css_animation(),
		G5P()->shortcode()->vc_map_add_animation_duration(),
		G5P()->shortcode()->vc_map_add_animation_delay(),
		G5P()->shortcode()->vc_map_add_extra_class(),
		G5P()->shortcode()->vc_map_add_css_editor(),
		G5P()->shortcode()->vc_map_add_responsive()
	),
);