<?php
/**
 * The template for displaying config.php
 *
 * @package WordPress
 * @subpackage ruby build
 * @since ruby build 1.0
 */
return array(
	'base'     => 'gsf_posts',
	'name'     => esc_html__('Posts', 'ruby-build-framework'),
	'category' => G5P()->shortcode()->get_category_name(),
	'icon'     => 'fa fa-file-text',
	'params'   => array_merge(
		array(
			array(
				'param_name'  => 'post_layout',
				'heading'     => esc_html__('Post Layout', 'ruby-build-framework'),
				'description' => esc_html__('Specify your post layout', 'ruby-build-framework'),
				'type'        => 'gsf_image_set',
				'value'       => array_merge(
					G5P()->settings()->get_post_layout(),
					array(
						'grid-2' => array(
							'label' => esc_html__('Grid 2', 'ruby-build-framework'),
							'img'   => G5P()->pluginUrl('assets/images/theme-options/blog-grid-2.png'),
						),
					)
				),
				'std'         => 'grid',
				'admin_label' => true
			),
			array(
				'param_name'  => 'posts_per_page',
				'heading'     => esc_html__('Posts Per Page', 'ruby-build-framework'),
				'description' => esc_html__('Enter number of posts per page you want to display. Default 9', 'ruby-build-framework'),
				'type'        => 'textfield',
				'std'         => 9
			),
			array(
				'param_name'       => 'show_cate_filter',
				'heading'          => esc_html__('Category Filter', 'ruby-build-framework'),
				'type'             => 'gsf_switch',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'std'              => '0'
			),
			array(
				'type'             => 'dropdown',
				'heading'          => esc_html__('Category Filter Alignment', 'ruby-build-framework'),
				'param_name'       => 'cate_filter_align',
				'value'            => array(
					esc_html__('Left', 'ruby-build-framework')   => 'cate-filter-left',
					esc_html__('Center', 'ruby-build-framework') => 'cate-filter-center',
					esc_html__('Right', 'ruby-build-framework')  => 'cate-filter-right'
				),
				'std'              => 'cate-filter-left',
				'dependency'       => array('element' => 'show_cate_filter', 'value' => 'on'),
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			),
			array(
				'param_name'  => 'post_columns_gutter',
				'heading'     => esc_html__('Post Columns Gutter', 'ruby-build-framework'),
				'description' => esc_html__('Specify your horizontal space between post.', 'ruby-build-framework'),
				'type'        => 'dropdown',
				'value'       => G5P()->shortcode()->switch_array_key_value(G5P()->settings()->get_post_columns_gutter()),
				'std'         => '30',
				'dependency'  => array('element' => 'post_layout', 'value' => array('grid', 'grid-2', 'masonry'))
			),
			array(
				'type'             => 'gsf_switch',
				'heading'          => esc_html__('Is Slider?', 'ruby-build-framework'),
				'param_name'       => 'is_slider',
				'std'              => '',
				'admin_label'      => true,
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			),
			array(
				'type'             => 'dropdown',
				'heading'          => esc_html__('Carousel Rows', 'ruby-build-framework'),
				'param_name'       => 'rows',
				'value'            => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4'
				),
				'dependency'       => array('element' => 'is_slider', 'value' => 'on'),
				'group'            => esc_html__('Slider Options', 'ruby-build-framework'),
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			),
			G5P()->shortcode()->vc_map_add_pagination(array(
				'dependency'       => array('element' => 'is_slider', 'value' => 'on'),
				'group'            => esc_html__('Slider Options', 'ruby-build-framework'),
				'edit_field_class' => 'vc_col-sm-6 vc_column'
			)),
			G5P()->shortcode()->vc_map_add_navigation(array(
				'dependency' => array('element' => 'is_slider', 'value' => 'on'),
				'group'      => esc_html__('Slider Options', 'ruby-build-framework'),
			)),
			G5P()->shortcode()->vc_map_add_navigation_position(array(
				'group' => esc_html__('Slider Options', 'ruby-build-framework')
			)),
			G5P()->shortcode()->vc_map_add_navigation_style(array(
				'group' => esc_html__('Slider Options', 'ruby-build-framework')
			)),
			G5P()->shortCode()->vc_map_add_autoplay_enable(array(
				'dependency' => array('element' => 'is_slider', 'value' => 'on'),
				'group'      => esc_html__('Slider Options', 'ruby-build-framework'),
			)),
			G5P()->shortCode()->vc_map_add_autoplay_timeout(array(
				'group' => esc_html__('Slider Options', 'ruby-build-framework'),
			)),
			array(
				'param_name'       => 'post_paging',
				'heading'          => esc_html__('Post Paging', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your post paging mode', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => array(
					esc_html__('No Pagination', 'ruby-build-framework')          => 'none',
					esc_html__('Pagination', 'ruby-build-framework')             => 'pagination',
					esc_html__('Ajax - Pagination', 'ruby-build-framework')      => 'pagination-ajax',
					esc_html__('Ajax - Next Prev', 'ruby-build-framework')       => 'next-prev',
					esc_html__('Ajax - Load More', 'ruby-build-framework')       => 'load-more',
					esc_html__('Ajax - Infinite Scroll', 'ruby-build-framework') => 'infinite-scroll'
				),
 'dependency' => array('element' => 'is_slider','value_not_equal_to' => array('on')),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'std'              => 'none'
			),
			array(
				'param_name'       => 'post_animation',
				'heading'          => esc_html__('Animation', 'ruby-build-framework'),
				'description'      => esc_html__('Specify your post animation', 'ruby-build-framework'),
				'type'             => 'dropdown',
				'value'            => G5P()->shortcode()->switch_array_key_value(G5P()->settings()->get_animation(true)),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'std'              => '-1'
			),
		),
		G5P()->shortcode()->get_post_filter(),
		G5P()->shortCode()->get_column_responsive(array(
			'element' => 'layout_style',
			'value'   => array('grid')
		)),
		array(
			G5P()->shortcode()->vc_map_add_css_animation(),
			G5P()->shortcode()->vc_map_add_animation_duration(),
			G5P()->shortcode()->vc_map_add_animation_delay(),
			G5P()->shortcode()->vc_map_add_extra_class(),
			G5P()->shortcode()->vc_map_add_css_editor(),
			G5P()->shortcode()->vc_map_add_responsive()
		)
	)
);