<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $our_team_layout
 * @var $show_category_filter
 * @var $show
 * @var $category
 * @var $our_teams_ids
 * @var $our_team_columns_gutter
 * @var $our_team_columns
 * @var $our_team_columns_md
 * @var $our_team_columns_sm
 * @var $our_team_columns_xs
 * @var $our_team_image_size
 * @var $our_team_image_ratio
 * @var $our_team_image_ratio_custom_width
 * @var $our_team_image_ratio_custom_height
 * @var $our_team_image_ratio_custom
 * @var $our_teams_per_page
 * @var $our_team_paging
 * @var $our_team_animation
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $el_class
 * @var $css
 * @var $responsive
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Our_Team
 */
$show= $our_team_layout = $show_category_filter = $category = $our_teams_ids = $our_team_columns_gutter = $our_team_columns =
$our_team_columns_md = $our_team_columns_sm = $our_team_columns_xs = $our_team_columns_mb =
$is_slider = $rows = $our_team_image_size = $our_team_image_ratio = $our_team_image_ratio_custom_width = $our_team_image_ratio_custom_height = $our_team_image_width =
$dots = $nav = $nav_position = $nav_style = $autoplay = $autoplay_timeout = $our_teams_per_page = $our_team_paging =
$our_team_animation = $css_animation = $animation_duration = $animation_delay = $el_class = $css = $responsive = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);

$our_team_image_ratio_custom = array(
	'width'  => $our_team_image_ratio_custom_width,
	'height' => $our_team_image_ratio_custom_height,

);
$our_team_image_width = array(
	'width' => $our_team_image_width
);
$wrapper_classes = array(
	'gf-our-team',
	'clearfix',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class($css),
	$responsive
);

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

$query_args = array(
	'post_type'      => 'our_team',
	'taxonomy'       => 'our_team_cat',
	'itemSelector'   => 'article',
	'posts_per_page' => (is_numeric($our_teams_per_page) && $our_teams_per_page > 0) ? $our_teams_per_page : '-1',
);

if ($show != 'our-teams') {
	if (!empty($category)) {
		$query_args['tax_query'][] = array(
			'taxonomy' => 'our_team_cat',
			'terms'    => explode(',', $category),
			'field'    => 'slug',
			'operator' => 'IN'
		);
		$category = G5P()->helper()->get_term_ids_from_slugs(explode(',', $category), 'our_team_cat');
		
	}
} else {
	$category = array();
	$show_category_filter = '';
}

switch ($show) {
	case 'new-in':
		$query_args['orderby'] = 'date';
		$query_args['order'] = 'DESC';
		break;
	case 'old-in':
		$query_args['orderby'] = 'date';
		$query_args['order'] = 'ASC';
		break;
	case 'our-teams':
		if (!empty($our_teams_ids)) {
			$our_teams_ids = explode(',', $our_teams_ids);
			$query_args['post__in'] = $our_teams_ids;
			$query_args['posts_per_page'] = -1;
			$query_args['orderby'] = 'post__in';
		}
		break;
}

if ('all' == $show) {
	$query_args['order'] = $order;
	$query_args['orderby'] = 'date';
}

$settings = array(
	'post_columns_gutter'    => $our_team_columns_gutter,
	'post_layout'            => $our_team_layout,
	'post_paging'            => $our_team_paging,
	'category_filter_enable' => false,
	'cat'                    => $category
);

if ('on' === $show_category_filter) {
	$settings['category_filter_enable'] = true;
	$settings['current_cat'] = -1;
	
}
if ($our_team_animation !== '') {
	$settings['post_animation'] = $our_team_animation;
}
$our_team_columns = intval($our_team_columns);
$our_team_columns_gutter = intval($our_team_columns_gutter);
$our_team_columns_md = intval($our_team_columns_md);
$our_team_columns_sm = intval($our_team_columns_sm);
$our_team_columns_xs = intval($our_team_columns_xs);
$our_team_columns_mb = intval($our_team_columns_mb);

if (in_array($our_team_layout, array('grid', 'masonry'))) {
	$settings['post_columns'] = array(
		'lg' => $our_team_columns,
		'md' => $our_team_columns_md,
		'sm' => $our_team_columns_sm,
		'xs' => $our_team_columns_xs,
		'mb' => $our_team_columns_mb,
	);
}

if ('on' === $is_slider) {
	$settings['post_paging'] = 'none';
	$carousel_class = '';
	if ($rows == 1) {
		$owl_args = array(
			'items'           => $our_team_columns,
			'margin'          => $our_team_columns == 1 ? 0 : $our_team_columns_gutter,
			'slideBy'         => $our_team_columns,
			'dots'            => ($dots === 'on') ? true : false,
			'nav'             => ($nav === 'on') ? true : false,
			'responsive'      => array(
				'1200' => array(
					'items'   => $our_team_columns,
					'margin'  => $our_team_columns == 1 ? 0 : $our_team_columns_gutter,
					'slideBy' => $our_team_columns,
				),
				'992'  => array(
					'items'   => $our_team_columns_md,
					'margin'  => $our_team_columns_md == 1 ? 0 : $our_team_columns_gutter,
					'slideBy' => $our_team_columns_md,
				),
				'768'  => array(
					'items'   => $our_team_columns_sm,
					'margin'  => $our_team_columns_sm == 1 ? 0 : $our_team_columns_gutter,
					'slideBy' => $our_team_columns_sm,
				),
				'600'  => array(
					'items'   => $our_team_columns_xs,
					'margin'  => $our_team_columns_xs == 1 ? 0 : $our_team_columns_gutter,
					'slideBy' => $our_team_columns_xs,
				),
				'0'    => array(
					'items'   => $our_team_columns_mb,
					'margin'  => $our_team_columns_mb == 1 ? 0 : $our_team_columns_gutter,
					'slideBy' => $our_team_columns_mb,
				)
			),
			'autoHeight'      => true,
			'autoplay'        => ($autoplay === 'on') ? true : false,
			'autoplayTimeout' => intval($autoplay_timeout),
		);
	} else {
		$settings['itemSelector'] = '.carousel-item';
		$owl_args = array(
			'items'           => 1,
			'margin'          => 0,
			'slideBy'         => 1,
			'dots'            => ($dots === 'on') ? true : false,
			'nav'             => ($nav === 'on') ? true : false,
			'autoHeight'      => true,
			'autoplay'        => ($autoplay === 'on') ? true : false,
			'autoplayTimeout' => intval($autoplay_timeout),
		);
		$settings['carousel_rows'] = array(
			'rows'       => intval($rows),
			'items_show' => $rows * $our_team_columns
		);
		$carousel_class = 'carousel-gutter-' . $our_team_columns_gutter;
	}
	if ($nav_style == 'nav-square-text' || $nav_style == 'nav-circle-text') {
		$owl_args['navText'] = array('<i class="fa fa-angle-left"></i> <span>' . esc_html__('Prev', 'ruby-build-framework') . '</span>', '<span>' . esc_html__('Next', 'ruby-build-framework') . '</span> <i class="fa fa-angle-right"></i>');
	}
	
	if ($nav === 'on') {
		$carousel_class .= ' ' . $nav_position . ' ' . $nav_style;
	}
	if (!empty($carousel_class)) {
		$settings['carousel_class'] = $carousel_class;
	}
	$settings['carousel'] = $owl_args;
}

$settings['image_size'] = $our_team_image_size;
$settings['image_ratio'] = $our_team_image_ratio;
$settings['image_ratio_custom'] = $our_team_image_ratio_custom;
$settings['image_width'] = $our_team_image_width;

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$class_to_filter .= vc_shortcode_custom_css_class($css, ' ');
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
?>
<div class="<?php echo esc_attr($css_class) ?>">
	<?php if (function_exists('g5plusRubyBuild')) {
		g5plusRubyBuild()->ourTeam()->archive_markup($query_args, $settings);
	} ?>
</div>