<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $css
 * @var $this WPBakeryShortCode_GSF_Our_Team_Info
 */
$el_class = $css_animation = $animation_duration = $animation_delay = $css = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);


$wrapper_classes = array(
	'gf-our-team-info',
	'clearfix',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class($css),
	$responsive
);

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);
$job_position = G5P()->metaBoxOurTeam()->get_our_team_job();
$job_experience= G5P()->metaBoxOurTeam()->get_our_team_details_job_experience();
?>
<div class="<?php echo esc_attr($css_class) ?>">
	<div class="our-team-title-wrap">
		<?php if (!empty($job_position)): ?>
			<h4 class="gsf-accent-text gsf-our-team-job fw-normal letter-spacing-03 uppercase fs-12 mg-bottom-5"><?php echo esc_attr($job_position); ?></h4>
		<?php endif; ?>
		<h4 class="gsf-our-team-title fw-normal letter-spacing-03 fs-18">
			<a title="<?php the_title() ?>" href="<?php the_permalink() ?>"><?php the_title() ?></a>
		</h4>
		<?php if (function_exists('g5plusRubyBuild')) {g5plusRubyBuild()->helper()->getTemplate('our-team/post-category');}  ?>
		<?php if (!empty($job_experience)): ?>
			<h4 class="gsf-accent-text gsf-our-team-job-ex fw-normal letter-spacing-03 fs-12 text-italic mg-top-10"><?php echo esc_attr($job_experience); echo esc_html__(' Work Experience', 'ruby-build-framework')?> </h4>
		<?php endif; ?>
	</div>
	<?php if (function_exists('g5plusRubyBuild')){g5plusRubyBuild()->helper()->getTemplate('our-team/post-share');}  ?>
</div>
